/**
 * pub-js-i18n
 * ===========
 *
 * Собирает *{lang}.pub.js*-файл языковых файлов, *js* и *bemhtml*.
 *
 * **Опции**
 *
 * * *String* **target** — Результирующий `pub.js`-файл. По умолчанию — `?.all.pub.js`.
 * * *String* **jsTarget** — Исходный `js`-файл. По умолчанию — `?.js`.
 * * *String* **lang** — Язык. Обязательная опция.
 * * *Array* **langTarget** — `lang.js`-файл конкретного языка. Например, `?.lang.ru.js`.
 *   По умолчанию — `?.lang.{lang}.js`.
 * * *Array* **allLangTarget** — `lang.all.js`-файл. По умолчанию — `?.lang.all.js`.
 * * *Array* **bemhtmlTarget** — `bemhtml.js`-файл. По умолчанию — `?.bemhtml.js`.
 */
module.exports = require('enb/lib/build-flow').create()
    .name('pub-js-i18n')
    .target('target', '?.{lang}.pub.js')
    .defineRequiredOption('lang')
    .useSourceFilename('bemhtmlTarget', '?.bemhtml.js')
    .useSourceFilename('allLangTarger', '?.lang.all.js')
    .useSourceFilename('langTarget', '?.lang.{lang}.js')
    .useSourceFilename('jsTarget', '?.js')
    .justJoinFilesWithComments()
    .createTech();