BEM.DOM.decl({ block: 'arrow-box', modName: 'type', modVal: 'native-select' }, {

    onSetMod:{

        'js':function () {

            this.__base.apply(this, arguments);

            this.currentValue = null;

            var selectElem = this.elem('select');

            var selected = this.elem('option', 'state', 'current');

            if (selected.length) {

                var params = this.elemParams(selected).arrowOpt;

                this.currentValue = params.value;

            } else {

                selectElem[0].selectedIndex = -1;

            }

        }

    },

    getSelected : function() {

        return this._selected;

    },

    reset: function() {},

    _onChange: function() {

        var _this = this,
            selectedId = _this._select[0].selectedIndex,
            selected = _this._opt.eq(selectedId),
            selectedOpt = _this.elemParams(selected).arrowOpt,
            name = selectedOpt && selectedOpt.name || null,
            value = selectedOpt && selectedOpt.value || null,
            options = this.findElem('option');

        _this._selected.text(name || _this._opt.eq(selectedId).text());

        $(options).removeClass('arrow-box__option_state_current');

        $(selected).addClass('arrow-box__option_state_current');

        this.currentValue = value || null;

        this.trigger('onChange');

        if(selectedOpt.link){

            window.location = selectedOpt.link;

        }

    },

    toggleState: function(){

        this.toggleMod('state', 'opened', '');

    },

    val: function() {

        return this.currentValue;

    },
    
    currentOptParams: function() {

        var currentOpt = this.findElem('option', 'state', 'current');

        if (!currentOpt.length) {

            return {
                value: '',
                name: ''
            }

        }

        var params = this.elemParams(currentOpt);

        return params.arrowOpt;

    },

    setDefault: function() {

        var selected = this.findElem('selected'),
            $domElem = $(this.domElem),
            $option = $domElem.find(this.buildSelector('option', 'state', 'current')),
            $options = $domElem.find(this.buildSelector('option')),
            current;

        if ($option.length) {

            current = $option.bem('arrow-box__option');

            current.delMod('state');

        }

        $options.removeAttr('selected');
        $options.first().attr('selected', 'selected');

        selected.text(this.params['default-name']);

        this.currentValue = null;

    },

    getState: function() {

        var current = this.findElem('option', 'state', 'current'),
            params = this.elemParams(current).arrowOpt;

        return {
            value: params.value,
            name: params.name
        };

    },

    setState: function(state) {

        var options = this.findElem('option'),
            _this = this,
            $options = $(options);

        var selectElem = this.elem('select');

        selectElem[0].selectedIndex = -1;

        $options.removeClass('arrow-box__option_state_current');

        $.each($options, function(i, option) {

            var $option = $(option),
                params = _this.elemParams($option).arrowOpt;

            if (params.value == state.value) {
                $option.addClass('arrow-box__option_state_current');

                selectElem[0].selectedIndex = i;
            }

        });

        this.currentValue = state.value;

        this._selected.text(state.name);

    }

});