(function () {
    BEM.DOM.decl({name: 'b-action-button', modName: 'type', modVal: 'show-hidden'}, {
        onSetMod: {

            js: function () {
                this.__base.apply(this, arguments);

                var $hideGoneButton,
                    $showGoneButton = this.domElem;

                this.bindTo('click', function () {
                    BEM.blocks['i-stat-counter'].reachGoal('SHOW-GONE');

                    var $lines = $('.b-routers__line:not(.b-routers__line_filtered_yes)');

                    $lines.removeClass('i-hidden');

                    if (!$hideGoneButton) {
                        $hideGoneButton = initHideGoneButton($showGoneButton);
                    }

                    var parent = $showGoneButton.parent();
                    $showGoneButton.detach();
                    parent.html($hideGoneButton);
                });
            }
        }
    });

    function initHideGoneButton($showGoneButton) {
        var $hideGoneButton = $(BEMHTML.apply({
            block: 'b-action-button',
            mods: {type: 'hide-gone'},
            mix: {block: 'b-routers', elem: 'action'},
            content: I18N('b-action-button', 'hide-gone')
        }));

        BEM.DOM.init($hideGoneButton);
        $hideGoneButton.on('click', function () {
            BEM.blocks['i-stat-counter'].reachGoal('HIDE-GONE');
            var $lines = $('.b-routers__line:not(.b-routers__line_filtered_yes)');

            $.each($lines, function (i, line) {
                var $line = $(line),
                    lineBlock = $line.bem('b-routers__line'),
                    params = lineBlock.params;

                if (params.gone) {
                    $line.addClass('i-hidden');
                }
            });

            var parent = $hideGoneButton.parent();
            $hideGoneButton.detach();
            parent.html($showGoneButton);
        });

        return $hideGoneButton;
    }
}());
