(function() {

var DOM = BEM.DOM;

DOM.decl({name: 'b-action-button', modName: 'type', modVal: 'stations'}, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            this.bindTo('click', this.expandStations);

        }
    },

    expandStations: function() {

        var _this = this,
            bStation = $(_this.domElem).parents('.b-station'),
            prev = bStation.prev(),
            stations;

        stations = $.map(_this.params['stations'], function(station, i) {

            var title = station.title,
                stopDuration = station.stopDuration;

            if (station.hasTechnicalStop) {
                title += ' <sup>(!)</sup>';
            }

            if (stopDuration && station.hasLongStop) {
                stopDuration = '<strong>' + stopDuration + '</strong>';
            }

            return {
                block: 'b-station',
                mods: {location: 'middle'},
                content: [
                    {
                        elem: 'illustration',
                        content: [{
                            block: 'b-route-scheme',
                            mods: {color: station.color, position: 'middle'},
                            content: [
                                {elem: 'road', elemMods: {position: 'before'}},
                                {elem: 'point'},
                                {elem: 'road', elemMods: {position: 'after'}}
                            ]
                        }]
                    },
                    {
                        elem: 'description',
                        elemMods: {stage: 'two'},
                        content: [
                            {
                                elem: 'city',
                                content: [{
                                    block: 'b-link',
                                    url: station.url,
                                    mods: { 'asterisk': station.hasTechnicalStop ? 'show' : '' },
                                    content: [
                                        {
                                            elem: 'text',
                                            mix: !station.url && [{block: 'g-font', mods: {color: 'grey'}}],
                                            content: title
                                        }
                                    ]
                                }]
                            },
                            {
                                elem: 'arrival-departure',
                                content: station.hasStop ? [
                                    {
                                        elem: 'wrapper-text',
                                        content: [
                                            station.stopTimeText
                                        ]
                                    },
                                    stopDuration && {
                                        elem: 'wrapper-text',
                                        content: [
                                            '&nbsp;*' + stopDuration
                                        ]
                                    }
                                ] : I18N('b-action-button', 'no-stop')
                            },
                            station.stateContent && {
                                elem: 'arrival-departure',
                                elemMods: { 'type': station.stateType === 'ok' ? 'ok' : 'delay' },
                                content: [
                                    station.stateContent
                                ]
                            }
                        ]
                    }
                ]
            };

        });

        bStation.remove();

        prev.after(BEMHTML.apply(stations));

    }

});

})();
