BEM.DOM.decl({ block : 'b-autocomplete-item', modName : 'nav', modVal : 'yes' }, {

   enter : function() {

       return false;

   },

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит пункт сам сделал все необходимые действия
     * @returns {Object.<needUpdate|needEvent>}
     */
    select : function(byKeyboard) {

        // открываем ссылку только когда выбрали с помощью клавиатуры, если выбрали мышкой, то сработает обычная ссылка
        byKeyboard && $('<form style="display:none" action="' + this.val() + '" target="_blank"/>')
            .appendTo('body')
            .submit()
            .remove();

        return { needEvent: true };

    }

}, {

    /**
     * Получить полную ссылку с протоколом
     * @param {String} url Ссылка
     * @returns {String}
     */
    getUrl : function(url) {

        return (url.match(/^\w[\w-]*:\/\//g)? '' : 'http://') + url;

    }

});
