BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'icon' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data').slice(1),
            text = data[0] || '',
            info = data[1] || {},
            escapeHTML = BEM.blocks['i-common__string'].escapeHTML,
            getUrl = BEM.blocks['b-autocomplete-item'].getUrl;

        // Если иконки нет
        if(!info.icon) return;

        var icons = {};

        // Если иконок несколько
        if(Array.isArray(info.icon[0])) {
            info.icon.forEach(function(icon) {
                icons[icon[0]] = icon[1];
            });
        } else { // Иначе иконка одна
            icons[info.icon[0]] = info.icon[1];
        }

        var svg = icons['svg'] ? 'background-image:none,url(' + icons['svg'] + ')' : '',
            png = icons['png'] ? 'background-image:url(' + icons['png'] + ');' : '';

        var content = [
            { tag: 'span', elem: 'text', content: escapeHTML(text) },
            {
                tag: 'i', elem: 'icon', attrs: {
                    style: png + svg
                }
            },
            { tag: 'span', elem: 'value', content: info.fact && escapeHTML(info.fact.replace('-', '&ndash;')) }
        ];

        if(info.url) {

            ctx
                .mod('nav', 'yes')
                .js({ val : getUrl(info.url) })
                .content({
                    block: 'b-autocomplete-item',
                    elem: 'nav',
                    url: info.url,
                    content: content
                });

        } else {
            ctx.content(content);
        }

    }

});
