BEM.DOM.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nav' }, {

    onSetMod : {

        js: function() {
            this.setMod('nav', 'yes');
        }

    },

    /**
     * __base в /_nav/b-autocomplete-item_nav_yes.js
     */
    enter : function() {
        return this.__base.apply(this, arguments);
    },

    /**
     * Действие на выбор пункта
     * __base в /_nav/b-autocomplete-item_nav_yes.js
     */
    select : function() {
        return this.__base.apply(this, arguments);
    }

});

BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nav' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data'),
            isV4 = ctx.param('suggestVersion') == 4,
            urlData = data[4] || data[3],
            url = (urlData.match(/^\w[\w-]*:\/\//g)? '' : 'http://') + urlData;

        ctx
            .js({ val : url })
            .content({
                elem : 'link',
                url  : url,
                title : BEM.blocks['i-common__string'].escapeHTML(isV4 ? data[3] : data[2]),
                description : BEM.blocks['i-common__string'].highlight(isV4 ? data[2] : data[1], ctx.param('hl'))
            });

    },

    onElem : {

        'link' : function(ctx) {

            ctx
                .tag('a')
                .attrs({ href : ctx.param('url'), target : '_blank' })
                .content([
                    { elem : 'link-url', tag : 'span', content : ctx.param('title') },
                    { elem : 'link-info', tag : 'span', content : ['&nbsp;&mdash; '].concat(ctx.param('description')) }
                ]);

        }


    }

});
