BEM.DOM.decl('b-avia-buy', {
    onSetMod: {
        js: function () {
            this.elem('icon').on('error', function () {
                this.setMod('hidden-image', 'yes');
            }.bind(this));

            if (this.getMod('state') === 'loading') {
                // нормальный прелоадер делать дорого
                // поэтому ждем 5 секунд и шлем запрос за вариантами
                // почти все партнеры за это время успевают ответить
                // так же этот прелоадер увидит, только при сохраненнии вкладки => вроде решение нормальное
                setTimeout(this._lazyInit.bind(this), 5000);
            }
        }
    },
    hide: function () {
        this.setMod('visibility', 'hidden');
    },
    show: function () {
        this.delMod('visibility');
    },
    _lazyInit: function () {
        $.get(this.params['update-url']).then(function (context) {
            var v = context.variant;
            if (context.state != 'form') {
                this._showNotFound();
                return;
            }
            // полностью перерисовывать контрол не имеет смысла.
            // иначе придется притащить кучу шаблонов на клиент, что не хочется делать.
            this.elem('price').html(v.tariff);
            this.elem('icon').attr('src', v.logo);
            this.elem('label').text(v.partner_title);
            this.delMod('hidden-image');
            this.elem('button').attr('href', v.deep_link);
            this.setMod('state', 'form');
            this.trigger('show');

        }.bind(this)).fail(this._showNotFound.bind(this));
    },
    _showNotFound: function () {
        this.setMod('state', 'not-found');

        // За 5 секунд пользователь сможет прочитать сообщение
        // После этого скрываем, чтобы не напрягать пользователей
        setTimeout(function () {
            this.setMod('state', 'error')
        }.bind(this), 5000);
    }
}, {
    live : function() {
        this.liveBindTo('click', function(e) {
            if (this.getMod('state') === 'form') {
                BEM.blocks['i-stat-counter'].reachGoal('REDIRECT_TO_AVIA_FROM_THREAD');
                window.open(this.elem('button').attr('href'), '_blank');
            }
        });
    }
});
