(function () {
var statCounter = BEM.blocks['i-stat-counter'];

BEM.DOM.decl('b-blablacar', {
    onSetMod: {
        js: function () {
            var awapsClickUrl = this.params.awapsClickUrl;

            if (this.getMod('loading') === 'yes') {
                statCounter.reachGoal('LOADING-BLABLACAR');
            }

            if (this.params.data) {
                this.setData(this.params.data);

                this.bindTo('click', function () {
                    statCounter.reachGoal('GO-TO-BLABLACAR');
                    if (awapsClickUrl) {
                        statCounter.awaps(awapsClickUrl, 'blablacar_click');
                    }
                });
            }
        }
    },

    hide: function () {
        this.setMod('loading', 'fail');

        statCounter.reachGoal('FAIL-BLABLACAR');
    },

    setData: function (data) {
        this.setMod('loading', 'success');
        var awapsShowUrl = this.params.awapsShowUrl;

        if (awapsShowUrl) {
            statCounter.awaps(awapsShowUrl, 'blablacar_show');
        }

        BEM.DOM.update(this.domElem, BEMHTML.apply(this.render(data)));

        if (this.getMod('loading') === 'success') {
            statCounter.reachGoal('READY-BLABLACAR');
        }
    },

    render: function (data) {
        return [{
            block: 'b-blablacar',
            elem: 'title',
            content: [
                {
                    elem: 'icon'
                },
                {
                    elem: 'title-text',
                    content: 'BlaBlaCar'
                }
            ]
        },{
            block: 'b-blablacar',
            elem: 'items',
            content: [
                {
                    elem: 'item-left',
                    content: [
                        {
                            block: 'b-link',
                            mix: [{block: 'b-route'}],
                            url: data.url,
                            content: data.route
                        },
                        {
                            elem: 'time',
                            content:  I18N('b-blablacar', 'duration-text') + ' ' + data.time
                        }
                    ]
                },
                {
                    elem: 'item-right',
                    content: [
                        {
                            elem: 'count',
                            content: data.count
                        },
                        {
                            elem: 'price',
                            content: data.tariff
                        }
                    ]
                }
            ]
        }];
    }
});
})();
