BEM.DOM.decl('b-board-route', {

    onSetMod: {

        js: function () {

            var _this = this;

            this.bindTo('item', 'click', function (e, data) {

                var domElem = e.data.domElem,
                    itemGetModChecked = _this.getMod(domElem, 'checked'),
                    itemGetModType = _this.getMod(domElem, 'type');

                if (['favorites', 'filter'].indexOf(itemGetModType) > -1) {

                    if (itemGetModChecked != 'yes') {

                        _this.setMod(domElem, 'checked', 'yes');

                        if (itemGetModType == 'filter') {
                            _this.buildFilters(this.params.initFilterValues);
                        }

                    } else {

                        _this.delMod(domElem, 'checked');

                        if (itemGetModType == 'filter') {
                            BEM.blocks['b-filters'].hide(data);
                        }

                    }
                }

                if (itemGetModType == 'route') {
                    var form = $('.b-form').bem('b-form'),
                        filterItem = _this.findElem('item', 'type', 'filter');

                    $('.b-transport-head').hide();

                    form.delMod('hidden');
                    _this.setMod('hidden', 'yes');

                    _this.delMod(domElem, 'checked');

                    _this.delMod(filterItem, 'checked');

                    if (BEM.blocks['b-filters'] != undefined) {

                        BEM.blocks['b-filters'].hide();

                    }

                    $('.b-content__item_type_form-container .b-content__button').hide();

                }

            });

        }

    },

    buildFilters: function (initFilterValues) {
        var table = $('.b-routers').bem('b-routers');

        BEM.blocks['b-filters'].build(table, initFilterValues || {});
    }

});
