(function () {
var statCounter = BEM.blocks['i-stat-counter'];

BEM.DOM.decl('b-buy', {
    onSetMod: {
        js: function () {

            this.selectedItem = this.params.selected_item;

            var klassChanger = this.findBlockInside('b-radio-group');

            if (klassChanger) {
                klassChanger.on('change', function (e, data) {
                    this.changeClass(data);
                }.bind(this));
            }

            this.bindTo('button', 'click', function () {
                this.buy();
                return false;
            });

            if (this.params.lazyInit) {
                BEM.blocks['i-stat-counter'].reachGoal('THREAD-BUY-LOADING');
                this.lazyInit();
            } else {
                BEM.blocks['i-stat-counter'].reachGoal('THREAD-BUY-READY', {
                    owner: this.params.train_order_url_owner
                });
            }
        }
    },

    hide: function () {
        this.setMod('visibility', 'hidden');
    },

    show: function () {
        this.delMod('visibility');
    },

    changeClass: function (data) {
        this.selectedItem = data.data;
        this.elem('result-txt').html(this.selectedItem.result_text);

        statCounter.reachGoal('CHANGE-COACH-CLASS', {
            klass: this.selectedItem.code,
            owner: this.params.train_order_url_owner
        });
    },

    buy: function () {
        var owner = this.params.train_order_url_owner;
        var train_order_url = this.selectedItem.train_order_url;

        if (owner === 'ufs') {
            statCounter.reachGoal('BUY-UFS-TICKET', {
                klass: this.selectedItem.code
            });
        } else {
            statCounter.reachGoal('BUY-TICKET', {
                klass: this.selectedItem.code
            });
        }


        if (owner === 'ufs') {
            setTimeout(function () {
                this.hide();
                window.location = train_order_url;
            }.bind(this), 1000);

            this.rerender({
                state: 'redirect'
            });
        } else {
            window.location = train_order_url;
        }
    },

    lazyInit: function () {
        $.ajax({
            url: this.params.buy_info_url
        }).then(function (data) {
            if (data.state === 'lazy-init') {
                setTimeout(this.lazyInit.bind(this), 3000);
                return;
            }

            if (data.state === 'error') {
                BEM.blocks['i-stat-counter'].reachGoal('THREAD-BUY-ERROR');
                this.trigger('error');
            }

            this.rerender(data);
        }.bind(this));
    },

    rerender: function (model) {
        var newHtml = null;

        if (model.state === 'redirect') {
            newHtml = this.renderRedirectToPartner();
        } else {
            if (model.state !== 'error') {
                newHtml = this.renderWithVariants(model);
            }
        }

        this.domElem = BEM.DOM.replace(this.domElem, BEMHTML.apply(newHtml));
    },

    renderWithVariants: function (model) {
        var isSingle = model.state === 'single-class';
        var coachElem;
        if (isSingle) {
            coachElem = this.singleCoach(model);
        } else {
            coachElem = this.multipleCoaches(model);
        }
        var mods = [];

        if (isSingle) {
            mods.type = 'single';
        }

        return {
            block: 'b-buy',
            js: {
                selected_item: model.selected_item,
                partner_site: model.partner_site,
                train_order_url_owner: model.train_order_url_owner
            },
            mods: mods,
            content: {
                elem: 'form',
                tag: 'form',
                content: [
                    !isSingle && {
                        elem: 'title',
                        content: I18N('b-buy', 'choose-coach-type')
                    },
                    coachElem,
                    this.seatResults(model.selected_item),
                    this.buyButton(model.train_order_url_owner)
                ]
            }
        };
    },

    renderRedirectToPartner: function () {
        return {
            block: 'b-buy',
            mods: {
                type: 'next'
            },
            content: [
                {
                    block: 'spin2',
                    js: true,
                    mods: {
                        size: 's', progress: 'yes'
                    }
                },
                {
                    elem: 'text',
                    content: I18N('b-buy', 'redirect-message')
                },
                {
                    elem: 'url',
                    tag: 'strong',
                    content: this.params.partner_site
                }
            ]
        };
    },

    coachItem: function (itemModel, checked) {
        var mods = {
            name: itemModel.code
        };

        if (checked) {
            mods.checked = 'yes';
        }

        return {
            elem: 'item',
            content: [
                {
                    elem: 'type',
                    tag: 'span',
                    content: itemModel.name
                },
                {
                    tag: 'button',
                    block: 'b-radio-group',
                    elem: 'item',
                    elemMods: mods,
                    js: {
                        data: itemModel
                    },
                    mix: [{
                        block: 'b-buy', elem: 'change-class-button'
                    }],
                    content: itemModel.tariff
                }
            ]
        };
    },

    buyButton: function (owner) {
        return {
            block: 'b-link',
            mix: [
                {
                    block: 'b-buy',
                    elem: 'button'
                }
            ],
            content: owner === 'ufs' ? I18N('b-buy', 'buy') : I18N('b-buy', 'select-place')
        };
    },

    seatResults: function (selectedItem) {
        return {
            elem: 'result',
            content: [
                {
                    elem: 'result-title',
                    content: I18N('b-buy', 'free-seats-title')
                },
                {
                    elem: 'result-txt',
                    content: selectedItem.result_text
                }
            ]
        };
    },

    singleCoach: function (model) {
        return {
            elem: 'coach-types',
            content: [
                {
                    elem: 'type',
                    tag: 'span',
                    content: model.selected_item.name
                },
                {
                    elem: 'price',
                    tag: 'span',
                    content: model.selected_item.tariff
                }
            ]
        };
    },

    multipleCoaches: function (model) {
        var variants = model.variants.map(function (variant, i) {
            return this.coachItem(variant, i === 0);
        }.bind(this));

        return {
            elem: 'coach-types',
            mix: [{
                block: 'b-radio-group',
                js: {
                    name: model.selected_item.code
                }
            }],
            content: {
                elem: 'items',
                content: variants
            }
        };
    }
});
}());
