(function () {

    BEM.DOM.decl({name: 'b-card', modName: 'switcher', modVal: 'maps'}, {

        onSetMod: {

            js: function () {
                var isMap = false,
                    wrapperMap = this.findBlockOutside('b-page').findBlockInside({ blockName: 'b-map'}),
                    content = this.findBlockOutside('b-content'),
                    tail = content.findElem('tail');

                this.bindTo('click tap', function () {
                    wrapperMap.toggleMod('visibility', 'hidden', '');
                    content.toggleMod(tail, 'visibility', 'hidden', '');
                    if (!isMap) {
                        isMap = true;
                        this.__onMap();
                    }
                });

            }

        },

        __onMap: function () {

            var params = this.params;

            ymaps.ready(init);

            function init() {
                var zoom = 15,
                    myMap = new ymaps.Map('map', {
                        center: [55.76, 37.64],
                        zoom: zoom
                    }),
                // Создадим пользовательский макет ползунка масштаба.
                    ZoomLayout = ymaps.templateLayoutFactory.createClass("<div class='b-map__controles-pane'>" +
                        "<div id='zoom-in' class='b-map__button b-map__button_type_plus'></div>" +
                        "<div id='zoom-out' class='b-map__button b-map__button_type_minus'></div>" +
                        "</div>", {

                        // Переопределяем методы макета, чтобы выполнять дополнительные действия
                        // при построении и очистке макета.
                        build: function () {

                            // Вызываем родительский метод build.
                            ZoomLayout.superclass.build.call(this);

                            // Привязываем функции-обработчики к контексту и сохраняем ссылки
                            // на них, чтобы потом отписаться от событий.
                            this.zoomInCallback = ymaps.util.bind(this.zoomIn, this);
                            this.zoomOutCallback = ymaps.util.bind(this.zoomOut, this);

                            // Начинаем слушать клики на кнопках макета.
                            $('#zoom-in').bind('click', this.zoomInCallback);
                            $('#zoom-out').bind('click', this.zoomOutCallback);

                        },

                        clear: function () {

                            // Снимаем обработчики кликов.
                            $('#zoom-in').unbind('click', this.zoomInCallback);
                            $('#zoom-out').unbind('click', this.zoomOutCallback);

                            // Вызываем родительский метод clear.
                            ZoomLayout.superclass.clear.call(this);

                        },

                        zoomIn: function () {

                            var map = this.getData().control.getMap();
                            // Генерируем событие, в ответ на которое
                            // элемент управления изменит коэффициент масштабирования карты.
                            this.events.fire('zoomchange', {
                                oldZoom: map.getZoom(),
                                newZoom: map.getZoom() + 1
                            });

                        },

                        zoomOut: function () {

                            var map = this.getData().control.getMap();

                            this.events.fire('zoomchange', {
                                oldZoom: map.getZoom(),
                                newZoom: map.getZoom() - 1
                            });

                        }

                    }),
                    zoomControl = new ymaps.control.SmallZoomControl({
                        layout: ZoomLayout
                    }),
                    initPlacemark = function (point) {

                        var myPlacemark = new ymaps.Placemark(point);

                        myMap.setCenter(point, zoom);
                        myMap.geoObjects.add(myPlacemark);

                    };

                myMap.controls.add(zoomControl, {right: 5, top: 5});

                if (!!params.coords) {

                    initPlacemark(params.coords);

                } else {

                    var geocoder = ymaps.geocode(params.address);

                    geocoder.then(
                        function (res) {

                            var point = res.geoObjects.get(0).geometry.getCoordinates();

                            initPlacemark(point);

                        }
                    );

                }

            }

        }


    })

})();