(function() {

function pad(str, width, fill) {

    while(str.length < width) {

        str = fill + str;

    }

    return str;

}

function groupDigits(digits) {

    var smallGroup = digits.substring(0, (digits.length - 1) % 3 + 1),
        groups = [smallGroup];

    for(var i = smallGroup.length; i < digits.length; i += 3) {

        groups.push(digits.substr(i, 3));

    }

    return groups.join(" ");

}

function format(fmt) {

    var values = Array.prototype.slice.call(arguments, 1),
        argIndex = 0;

    return fmt.replace(/%(%|\d*d)/g, function (str, options) {

        if(options == '%') {

            return '%';

        }

        var value = Math.floor(values[argIndex++]),
            width = options.substr(0, options.length - 1);

        if(width.length) {

            var fill = " ";

            if(width.length > 1 && width.charAt(0) == '0') {
                fill = '0';
                width = width.substr(1);
            }

            return pad(String(value), parseInt(width), fill);

        }

        return groupDigits(String(value));

    });

}

function formatCurrency(params) {

    var info = BEM.blocks['i-global'].param('currency'),
        displayedCurrency,
        data,
        displayedValue,
        showCents = params.cents,
        whole, cents,
        unitWrapper = '$1',
        result;

    if(typeof params.currency == 'undefined')
        params.currency = info.base;

    if(info.rates.hasOwnProperty(params.currency)) {

        var baseValue = params.value * info.rates[params.currency];

        displayedCurrency = info.selected;
        displayedValue = baseValue / info.rates[displayedCurrency];

    } else {

        // Currency base rate unavailable, cannot convert, displaying native value
        displayedCurrency = params.currency;
        displayedValue = params.value;

    }

    whole = Math.floor(displayedValue);
    cents = Math.round((displayedValue - whole) * 100);

    if(displayedValue < 200) {

        showCents = true;

    }

    data = info.formats[displayedCurrency];

    if(showCents && cents) {
        if(whole) {

            result = format(data.template, whole, cents);

        } else {

            result = format(data.template_cents, cents);

        }
    } else {

        result = format(data.template_whole, whole);

    }

    result = result.replace(/<unit>(.*?)<\/unit>/g, unitWrapper);

    if(params.from) {

        result = 'от ' + result;

    } else if(params.roughly) {

        result = '~ ' + result;

    }

    return result;

}

BEM.channel('currency').on('change', function(e) {

    $.cookie('preferredcurrency', BEM.blocks['i-global'].param('currency').selected, { path: '/' });

});

BEM.DOM.decl('b-currency', {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            BEM.channel('currency').on('change', this._onCurrencyChange, this);

        }

    },

    destruct : function() {

        BEM.channel('currency').un('change', this._onCurrencyChange, this);

        this.__base.apply(this, arguments);

    },


    _onCurrencyChange : function(e, currency) {

        BEM.DOM.update(this.domElem, formatCurrency(this.params));

    }
}, {

    toSelectedCurrency: function(baseValue) {

        var info = BEM.blocks['i-global'].param('currency');

        return baseValue / info.rates[info.selected];

    },

    fromSelectedCurrency: function(displayedValue) {

        var info = BEM.blocks['i-global'].param('currency');

        return displayedValue * info.rates[info.selected];

    },

    rebase: function(params) {

        if(typeof params.baseValue != 'undefined')
            return params;

        var info = BEM.blocks['i-global'].param('currency');

        if(info.rates.hasOwnProperty(params.currency)) {

            params.baseValue = params.value * info.rates[params.currency];

        }

        return params;

    }

});

BEM.HTML.decl('b-currency', {

    onBlock : function(ctx) {

        var params = ctx.js();

        ctx
            .tag('span')
            .js(params)
            .content(formatCurrency(params));

    }

});

})();
