BEM.DOM.decl('b-datepicker', {

    onSetMod: {

        js: function() {

            var switcher = this.findBlockInside('b-month-switcher'),
                submitButton = this.findBlockInside('button'),
                nextSwitchers = this.domElem.find(switcher.buildSelector('switch', 'arrow-type', 'next'))
                                            .not(switcher.buildSelector('switch', 'disabled', 'yes')),
                prevSwitchers = this.domElem.find(switcher.buildSelector('switch', 'arrow-type', 'prev'))
                                            .not(switcher.buildSelector('switch', 'disabled', 'yes'));

            this.bindTo(nextSwitchers, 'click', this.onNextMonth);
            this.bindTo(prevSwitchers, 'click', this.onPrevMonth);

        }
    },

    getCurrentSwitcher: function() {

        return $('.b-month-switcher_state_current');

    },

    getCurrentCalendar: function() {

        return $('.b-calendar_state_current');

    },

    onNextMonth: function(e) {

        e.preventDefault();

        var currentSwitcher = this.getCurrentSwitcher(),
            nextSwitcher = $(currentSwitcher).next('.b-month-switcher').bem('b-month-switcher'),
            currentCalendar = this.getCurrentCalendar(),
            nextCalendar = $(currentCalendar).next('.b-calendar').bem('b-calendar');

        nextSwitcher.setMod('state', 'current');
        currentSwitcher.bem('b-month-switcher').setMod('state', 'hidden');

        nextCalendar.setMod('state', 'current');
        currentCalendar.bem('b-calendar').setMod('state', 'hidden');

    },

    onPrevMonth: function(e) {

        e.preventDefault();

        var currentSwitcher = this.getCurrentSwitcher(),
            prevSwitcher = $(currentSwitcher).prev('.b-month-switcher').bem('b-month-switcher'),
            currentCalendar = this.getCurrentCalendar(),
            prevCalendar = $(currentCalendar).prev('.b-calendar').bem('b-calendar');

        prevSwitcher.setMod('state', 'current');
        currentSwitcher.bem('b-month-switcher').setMod('state', 'hidden');

        prevCalendar.setMod('state', 'current');
        currentCalendar.bem('b-calendar').setMod('state', 'hidden');

    }
});