(function () {

var DOM = BEM.DOM,
    BaseFilter = $.inherit({

        __constructor: function (params) {

            this.name = params.name;

            this.param = params.param;

            this.defaultName = params.defaultName;

            this.block = null;

            this.options = [];

        },

        init: function (lines) {

            $.each(lines, function (i, line) {
                var filterOptions = line.params[this.param];

                if (filterOptions === undefined || filterOptions === null) {
                    return;
                }

                $.each(filterOptions, function (j, filterOption) {
                    if (this.options.some(function (option) { return option.value === filterOption.value })) {
                        return;
                    }
                    this.options.push(filterOption);
                }.bind(this));
            }.bind(this));
        },

        bind: function () {

            this.block = BEM.blocks['b-filter'].instances[this.param];

        },

        isActive: function () {

            return this.options.length > 1;

        },

        apply: function (lines) {

            this.reduce(lines);

        },

        reduce: function (lines) {
            var filterValue = this.block.val();

            if (!filterValue) {
                return;
            }

            $.each(lines, function (i, line) {
                var lineParam = line.params[this.param],
                    $domElem = $(line.domElem);

                if (!this.isFilteredLine(filterValue, lineParam)) {
                    $domElem.addClass('b-routers__line_filtered_yes i-hidden');
                }

            }.bind(this));
        },

        isFilteredLine: function (filterValue, lineParam) {
            if (!$.isArray(lineParam) || !lineParam.length) {
                return false;
            }

            return lineParam.some(function (option) {
                return option.value === filterValue;
            });
        },

        build: function () {},

        reset: function () {

            this.block.reset();

        }

    }),
    SelectFilter = $.inherit(BaseFilter, {

        _getOptions: function () {
            return $.merge([{name: this.defaultName, value: null}], this.options);
        },

        getOptions: function () {
            var options = this._getOptions();

            var initValue = this.initValue || null;
            for (var i = 0 ; i < options.length; i += 1) {
                if (options[i].value === initValue) {
                    options[i].current = true;
                    break;
                }
            }

            return options;
        },

        build: function () {

            return {
                block: 'b-filter',
                js: {param: this.param},
                content: [
                    {
                        block: 'b-title',
                        mods: {type: 'route'},
                        content: this.name
                    },
                    {
                        block: 'arrow-box',
                        js: {'default-name': this.defaultName},
                        mods: {
                            type: 'native-select'
                        },
                        arrowOpt: this.getOptions(),
                        content: ['', {
                            elem: 'selected', content: this.defaultName
                        }]
                    }
                ]
            };

        }

    }),
    HorizontalSelectorFilter = $.inherit(SelectFilter, {
        __constructor: function (params) {
            this.__base(params);
        },
        build: function () {
            var selectedValue = '';
            var items = this.getOptions().map(function (selectItem) {
                if (selectItem.current) {
                    selectedValue = selectItem.value;
                }
                return {
                    elem: 'button',
                    js: {
                        value: selectItem.value
                    },
                    elemMods: {
                        position: 'middle',
                        checked: selectItem.current ? 'yes' : 'no'
                    },
                    content: {
                        elem: 'text',
                        content: selectItem.name
                    }
                };
            });

            if (items.length > 1) {
                items[0].elemMods.position = 'left';
                items[items.length - 1].elemMods.position = 'right';
            }

            var count = {
                2: 'two',
                3: 'three',
                4: 'four'
            };

            return {
                block: 'b-filter',
                js: {
                    param: this.param
                },
                mods: {
                    type: 'switcher'
                },
                content: {
                    block: 'b-switcher',
                    js: {
                        value: selectedValue
                    },
                    mods: {
                        type: 'filter',
                        count: count[items.length]
                    },
                    content: items
                }
            };
        }
    }),
    ExistFilter = $.inherit(HorizontalSelectorFilter, {
        __constructor: function (params, translates) {
            this.translates = translates;
            this.__base(params);
        },
        _getOptions: function () {
            var translates = this.translates;
            return [
                {
                    name: translates.defaultName,
                    value: ''
                }, {
                    name: translates.yesName,
                    value: 'yes'
                }, {
                    name: translates.noName,
                    value: 'no'
                }
            ];
        }
    }),
    PriceFilter = $.inherit(ExistFilter, {
        __constructor: function () {
            this.__base({
                    param: 'has-price'
                }, {
                    defaultName: I18N('b-filters', 'ignore-filter-name'),
                    yesName: I18N('b-filters', 'show-with-price-filter-name')
                });
        },
        _getOptions: function () {
            var options = this.__base();
            options.pop();
            return options;
        },
        init: function () {}, // так как не нужны значения всех имеющихся цен
        isActive: function () { // так как цены подгружаются динамически
            return true;
        }
    }),
    TimeSelectFilter = $.inherit(SelectFilter, {

        init: function (lines) {
            this.__base(lines);

            var valuesOrder = {morning: 0, day: 1, evening: 2, night: 3};
            this.options.sort(function (a, b) {
                return valuesOrder[a.value] - valuesOrder[b.value];
            });
        }

    }),
    SortSelect = $.inherit({

        __constructor: function (opts) {

            this.param = 'sort';
            this.opts = opts;

        },

        init: function () {},

        bind: function () {

            this.block = BEM.blocks['b-filter'].instances[this.param];

        },

        build: function () {

            return {
                block: 'b-filter',
                js: {param: this.param},
                content: [
                    {
                        block: 'b-title',
                        mods: {type: 'route'},
                        content: I18N('b-filters', 'sorting-selector-title')
                    },
                    {
                        block: 'arrow-box',
                        js: {'default-name': I18N('b-filters', 'sorting-selector-departure-value')},
                        mods: {type: 'native-select', sort: 'yes'},
                        arrowOpt: this.opts,
                        content: ['', {
                            elem: 'selected',
                            content: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure'
                        }]
                    }
                ]
            };

        },

        isActive: function () {

            return true;

        },

        apply: function () {

            var arrowBox = this.block.findBlockInside('arrow-box');

            arrowBox.sort();

        },

        reset: function () {

            var arrowBox = this.block.findBlockInside('arrow-box');

            arrowBox.reset();

        }

    }),
    filterSet = {
        train: [
            new SelectFilter({
                name: I18N('b-filters', 'tickets-filter-name'),
                param: 'tickets',
                defaultName: I18N('b-filters', 'any-plural')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-station-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-station-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'},
                {name: I18N('b-filters', 'sorting-selector-price-value'), value: 'price'}
            ])
        ],
        plane: [
            new SelectFilter({
                name: I18N('b-filters', 'aviacompany-filter-name'),
                param: 'company',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-airport-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-airport-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any')
            }),
//            new CheckboxFilter({
//                name: 'Чартеры',
//                param: 'is-charter'
//            }),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'},
                {name: I18N('b-filters', 'sorting-selector-price-value'), value: 'price'}
            ])
        ],
        bus: [
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-station-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-station-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'},
                {name: I18N('b-filters', 'sorting-selector-price-value'), value: 'price'}
            ])
        ],
        suburban: [
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-station-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-station-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'}
            ]),
            new ExistFilter({
                    param: 'is-aeroex'
                }, {
                    defaultName: I18N('b-filters', 'ignore-filter-name'),
                    yesName: I18N('b-filters', 'aeroexpress-filter-name'),
                    noName: I18N('b-filters', 'suburban-filter-name')
                }),
            new ExistFilter({
                    param: 'is-express'
                }, {
                    defaultName: I18N('b-filters', 'ignore-filter-name'),
                    yesName: I18N('b-filters', 'express-filter-name'),
                    noName: I18N('b-filters', 'suburban-filter-name')
                })
        ],
        water: [
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-station-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-station-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'},
                {name: I18N('b-filters', 'sorting-selector-price-value'), value: 'price'}
            ])
        ],
        all: [
            new PriceFilter(),
            new SortSelect([
                {name: I18N('b-filters', 'sorting-selector-departure-value'), value: 'departure', current: true},
                {name: I18N('b-filters', 'sorting-selector-arrival-value'), value: 'arrival'},
                {name: I18N('b-filters', 'sorting-selector-travel-time-value'), value: 'travel_time'},
                {name: I18N('b-filters', 'sorting-selector-price-value'), value: 'price'}
            ]),
            new TimeSelectFilter({
                name: I18N('b-filters', 'departure-time-filter-name'),
                param: 'departure-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new TimeSelectFilter({
                name: I18N('b-filters', 'arrival-time-filter-name'),
                param: 'arrival-time',
                defaultName: I18N('b-filters', 'any-neuter')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'departure-station-filter-name'),
                param: 'station-from',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'arrival-station-filter-name'),
                param: 'station-to',
                defaultName: I18N('b-filters', 'any-feminine')
            }),
            new SelectFilter({
                name: I18N('b-filters', 'company-filter-name'),
                param: 'company',
                defaultName: I18N('b-filters', 'any-feminine')
            })
        ]
    };

DOM.decl('b-filters', {

    onSetMod: {

        js: function () {

            this.filters = [];

        }

    },

    reduce: function () {
        var $allLines = $('.b-routers__line');

        var $lines = $allLines.not('.b-routers__line_type_head-line').not('.b-routers__line_type_blablacar'),
            $message = $('.error-message'),
            $attentions = $('.b-details-router__line_type_attention'),
            lines;

        $allLines.removeClass('i-hidden');

        $lines.removeClass('b-routers__line_filtered_yes');

        $attentions.show();
        $message.hide();

        lines = $lines.map(function () {

            return $(this).bem('b-routers__line');

        });

        $.each(this.filters, function (i, filter) {

            filter.apply(lines);

        });

        var $actualLines = $lines.not('.b-routers__line_filtered_yes');
        var $goneRoutes = $actualLines.filter('.b-routers__line_gone_yes');
        var $routes = $actualLines.not('.b-routers__line_gone_yes');
        var $headLine = $('.b-routers__line_type_head-line');
        var hideGone = $('.b-action-button_type_show-hidden', $headLine)[0];

        $headLine.removeClass('i-hidden');

        if ($goneRoutes.length && $routes.length) {

            // скрываем ушедшие, если нужно, показываем кнопку

            if (hideGone) {
                $goneRoutes.addClass('i-hidden');
            } else {
                $goneRoutes.removeClass('i-hidden');
            }

            $routes.removeClass('i-hidden');

            $headLine.removeClass('i-hidden');

        } else if ($goneRoutes.length && !$routes.length) {

            // показываем ушедшие, скрываем кнопку

            $goneRoutes.removeClass('i-hidden');

            $headLine.addClass('i-hidden');

        } else if (!$goneRoutes.length && $routes.length) {

            // скрываем кнопку, показываем рейсы

            $goneRoutes.addClass('i-hidden');

            $routes.removeClass('i-hidden');

            $headLine.addClass('i-hidden');

        } else {

            // все скрываем

            $allLines.addClass('i-hidden');

            $headLine.addClass('i-hidden');

            $attentions.hide();

            $message.show();

            var html = BEMHTML.apply({
                block: 'b-message',
                mods: {type: 'null-search-result'},
                content: [
                    {
                        elem: 'item',
                        content: I18N('b-filters', 'routes-not-found')
                    },
                    {
                        elem: 'item',
                        content: I18N('b-filters', 'no-filtered-routes')
                    }
                ]
            });

            $message.html(html);

        }

    },

    reset: function () {

        $('.error-message').hide();

        $.each(this.filters, function (i, filter) {

            filter.reset();

        });

    },

    update: function (table, initValues) {

        var filters = filterSet[table.params.search_type],
            $item = $('.b-content__item_type_form-container'),
            lines;

        filters.forEach(function (f) {
            if (initValues.hasOwnProperty(f.param)) {
                f.initValue = initValues[f.param];
            }
        });

        var $lines = $('.b-routers__line').not('.b-routers__line_type_head-line');

        lines = $.map($lines, function (line) {

            return $(line).bem('b-routers__line');

        });

        this.filters = $.grep(filters, function (filter) {

            filter.init(lines);

            return filter.isActive();

        });

        var content = this.content();

        $item.append($(this.domElem));

        DOM.update(this.domElem, content);

        var currentFilterValues,
            previousFilterValues;

        $('.button_type_filter').on('click', function () {

            if ($lines.length) {
                currentFilterValues = this.filters.map(function (f) {
                    return f.block.val();
                });

                var changed_filters = currentFilterValues.join('!!!') !== previousFilterValues.join('!!!');
                BEM.blocks['i-stat-counter'].reachGoal('USE-FILTER', {
                    action: changed_filters ? 'apply' : 'false-apply'
                });

                this.reduce();

                previousFilterValues = currentFilterValues;

            }

            var filterButton = $('.b-board-route__item_type_filter');
            if (!filterButton[0]) {
                filterButton = $('.b-action-button_type_filter');
            }
            filterButton.trigger('click', {
                applyFilter: true
            });

        }.bind(this));

        this.bindFilters();
        previousFilterValues = this.filters.map(function (f) {
            return f.block.val();
        });

    },

    bindFilters: function () {

        $.each(this.filters, function (i, filter) {

            filter.bind();

        });

    },

    content: function () {

        var filters;

        filters = $.map(this.filters, function (filter) {

            return filter.build();

        });

        if (filters.length) {

            $.merge(filters, [{
                block: 'b-filters',
                elem: 'line',
                elemMods: {type: 'submit'},
                content: [
                    {
                        block: 'button',
                        mods: {theme: 'yellow', size: 'xl', type: 'filter'},
                        content: I18N('b-filters', 'submit-filter')
                    },
                    {
                        block: 'b-action-button',
                        attrs: {type: 'button'},
                        mods: {type: 'reset-filter'},
                        js: true,
                        content: I18N('b-filters', 'reset-filter')
                    }
                ]
            }]);

        } else {

            filters = [{
                block: 'b-filter',
                js: {param: this.param},
                content: [
                    {
                        block: 'b-title',
                        mods: {type: 'route'},
                        content: I18N('b-filters', 'empty-filter')
                    }
                ]
            }];

        }

        return $(BEMHTML.apply(filters));

    }
}, {

    build: function (table, initValues) {

        var $block = $('.b-filters'),
            block = $(BEM.HTML.build({
                block: 'b-filters',
                mods: {type: 'route'}
            })).bem('b-filters');

        $('.b-content__item_type_form-container .b-content__button').hide();

        BEM.blocks['i-stat-counter'].reachGoal('USE-FILTER', {
            action: 'show'
        });

        if ($block.length) {

            $block.show();

            return $block.bem('b-filters');

        }

        block.update(table, initValues);

        return block;

    },

    hide: function (data) {
        if (!data  || !data.applyFilter) {
            BEM.blocks['i-stat-counter'].reachGoal('USE-FILTER', {
                action: 'hide'
            });
        }

        $('.b-content__item_type_form-container .b-content__button').show();

        $('.b-filters').hide();

    }
});

})();
