BEM.DOM.decl({name: 'b-form-input', modName: 'pick', modVal: 'yes'}, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var _this = this,
                keyInput = this.findElem('key');

            this._keyInput = keyInput.length ? keyInput : $('<input type="hidden" name="' + this.params['key-name'] + '" />').appendTo(this.domElem);

            this.params.dataprovider.input = this;

            this.on('clear', function() {

                _this.keyVal('');

            });

            this.on('update-items', function() {

                if(_this._preselected)
                    $.each(this._metaItems, function(i) {

                        if(this[0] && this[0] == _this._preselected.key || this[1] == _this._preselected.text)
                            _this._onEnterItem(_this._items[i]);

                    });

                this.del('_preselected');

            });

            this.on('data-received', function(e, data) {

                this._enteredVal = this.val();

            });
        }
    },

    _onSelectItem: function(item, byKeyboard) {

        var name = this.name(),
            _this = this,
            form = $('.b-form').bem('b-form'),
            inputs = form.getInputs();

        var needUpdate = item.select(byKeyboard || false) !== false;

        _this._preventRequest = true;

        needUpdate && _this
            .val(
                _this._userVal = item.val(),
                { source : 'autocomplete', itemIndex: this._curItemIndex })
            ._getPopup().hide();

        if(byKeyboard) {
            _this.del('_preventRequest');
        } else {
            needUpdate || (_this._preventHide = true);
        }

        needUpdate && _this.trigger('select', { item: item, byKeyboard: byKeyboard });

        if (name == 'fromName') {
            _this.afterCurrentEvent(function() {
                _this.delMod('focused');

                inputs.toName.setMod('focused', 'yes');
            });
        }

        if (name == 'cityFrom') {
            _this.afterCurrentEvent(function() {
                var id = _this.keyVal().slice(1);

                window.location = '/city/' + id;
            });
        }

    },

    _getPopup : function() {

        var _this = this;

        if(!_this._popup) {

            var keyDownEvent = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown',
                block = _this.__self.getName(),
                content = [{ elem : 'items', tag : 'ul', mix : [{ block : block, elem : 'popup-items' }]},
                    { block: 'b-form-input', elem: 'shadow', tag: 'i' }
                ];

            _this._hasPopupFade() && content.push({ block : block, elem : 'fade' });

            _this._popup = $(BEM.HTML.build({
                    block : 'i-popup',
                    mix : [
                        {
                            block : block,
                            elem : 'popup',
                            mods : _this.params.popupMods,
                            js : { uniqId: _this._uniqId }
                        }
                    ],
                    content : content
                })).bem('i-popup')
                    .on({
                        'show' : function() {
                            _this
                                .trigger('popup-shsown')
                                .bindTo('keypress', _this._onKeyPress)
                                .bindToWin('resize', _this._updatePopupPos)
                                .unbindFrom('input', 'click')
                                .unbindFrom('input', 'tap')
                                ._isPopupShown = true;
                        },
                        'outside-click' : function(e, data) {
                            _this.containsDomElem($(data.domEvent.target)) && e.preventDefault();
                        },
                        'hide' : function() {
                            _this
                                .trigger('popup-hidden')
                                .unbindFrom('keypress')
                                .unbindFromWin('resize')
                                .bindTo('input', 'click', _this._getHiddenPopup)
                                .bindTo('input', 'tap', _this._getHiddenPopup)
                                ._curItemIndex = -1;
                            _this._isPopupShown = false;
                        }
                    });

            _this.bindTo(keyDownEvent, _this._onKeyDown);
            _this.bindTo('tap', _this._onKeyDown);

            $.each({
                mouseover : _this._onEnterItem,
                mouseout  : _this._onLeaveItem,
                mousedown : _this._onSelectItem,
                tap       : _this._onSelectItem,
                mouseup   : _this._onItemMouseUp
            }, function(e, fn) {
                BEM.blocks['b-autocomplete-item'].on(_this._popup.domElem, e, function(e) {
                    fn.call(_this, e.block);
                });
            });

            BEM.DOM.init(_this._popup.domElem);
        }

        return _this._popup;

    },

    _doRequest : function() {

        var _this = this,
            reqVal = _this.val();

        _this.enablePopup();
        _this._userVal = _this.val();

        _this
            .trigger('data-requested')
            .getDataprovider().get(
                reqVal,
                function(data) {
                    if(reqVal != _this.val()) { // Опоздали
                        return;
                    }

                    _this.trigger('data-received', data);

                    var popup = _this._getPopup(),
                        dataItems = data.items || data;

                    _this.foot && dataItems.length && ($.inArray(_this.foot, dataItems) == -1) && dataItems.push(_this.foot);

                    if(dataItems.length) {
                        _this._curItemIndex = -1;
                        BEM.DOM.update(popup.elem('items'), _this._buildItemsHtml(dataItems), function() {
                            _this._updatePopupPos();
                            _this._items = popup.findBlocksInside('b-autocomplete-item');
                            _this.trigger('update-items');
                        });
                    } else {
                        popup.hide();
                    }
                });

    },

    _buildItemsHtml : function(data) {


        if ($('.b-content_calendar_yes').is(':visible')) {
            return;
        }

        this._metaItems = data;

        data = $.map(data, function(item) {
            return item[2];
        });

        return this.__base.call(this, data);

    },

    val : function(val, data) {

        if(data && data.source == 'autocomplete') {


            var item = this._metaItems[data.itemIndex],
                key = item[0];

            val = item[1];

            this.keyVal(key);

            // Уточнение не окончательно, продолжаем
            !key && val != this.val() && this._doRequest();

        }

        if(data && data.preventRequest && !this._preventRequest) {
            this._preventRequest = true;

            this.afterCurrentEvent(function() {
                this.del('_preventRequest');
            });
        }

        return this.__base.call(this, val, data);

    },

    keyVal : function(val) {

        if(typeof val == 'undefined')
            return this._keyInput.val();

        this._keyInput.val(val);

        this.trigger('keyChange');

        return this;

    },

    getState: function() {
        return this._getState();
    },

    setState: function(state) {
        this._setState(state);
    },

    _getState : function() {

        return {

            val: this.val(),
            keyVal: this.keyVal(),
            _enteredVal: this._enteredVal,
            _preselected: this._preselected

        };

    },

    _setState : function(state) {

        this._enteredVal = state._enteredVal;
        this._preselected = state._preselected;

        this.val(state.val, { preventRequest: true });
        this.keyVal(state.keyVal);

    }
});
