(function () {

var DOM = BEM.DOM,
    GLOBAL = BEM.blocks['i-global'];

DOM.decl({name: 'b-form', modName: 'type', modVal: 'suburban'}, {

    onSetMod: {

        js: function () {

            this.__base.apply(this, arguments);

            var _this = this,
                directions = this.findBlockInside({block: 'arrow-box', modName: 'direction', modVal: 'list'}),
                stations = {},
                inputs;

            inputs = this.findBlocksInside('input');

            if (inputs.length) {

                $.each(inputs, function (i, input) {

                    _this[input.name()] = input;

                });

            } else {

                $.each(this.findBlocksInside({block: 'arrow-box', modName: 'direction', modVal: 'stations'}), function (i, select) {

                    _this[select.params.name] = select;

                });

            }

            directions.on('onChange', function () {

                _this.updateWidgets(this.val());

            });

        }
    },

    updateWidgets: function (dir, reset) {

        reset = reset || false;

        var _this = this,
            selects = _this.findBlocksInside({block: 'arrow-box', modName: 'direction', modVal: 'stations'}),
            states = {
                from: {
                    value: this.params.fromId,
                    name: this.params.fromName,
                    keyVal: this.params.fromId,
                    val: this.params.fromName
                },
                to: {
                    value: this.params.toId,
                    name: this.params.toName,
                    keyVal: this.params.toId,
                    val: this.params.toName
                }
            };

        if (dir == null) {

            $.each(selects, function (i, select) {

                var name = select.params.name,
                    $input = $(BEMHTML.apply(_this.inputBlock(name))),
                    input = $input.bem('input');

                $(select.domElem).replaceWith($input);

                DOM.init($input);

                _this[name] = input;

                if (reset) {

                    input.setState(states[name]);

                }

            });

            return;

        }

        $.ajax({
            url: GLOBAL.param('touch-url') + '/direction_stations/' + dir + '/',
            dataType: 'jsonp',
            crossDomain: true,
            traditional: true,
            timeout: 5000,
            success: function (response, textStatus) {

                if (selects.length) {

                    $.each(selects, function (i, select) {

                        var name = select.params.name,
                            base_station = i == 0 ? response.base_station : {
                                title: '',
                                key: ''
                            },
                            $arrowBox = $(BEMHTML.apply(_this.arrowBox(name, response.stations, base_station))),
                            arrowBox = $arrowBox.bem('arrow-box');

                        $(select.domElem).replaceWith($arrowBox);

                        DOM.init($arrowBox);

                        _this[name] = arrowBox;

                        if (reset) {

                            arrowBox.setState(states[name]);

                        }

                    });

                    return;

                }

                var inputs = _this.findBlocksInside('input');

                $.each(inputs, function (i, input) {

                    var name = input.params.name,
                        base_station = i == 0 ? response.base_station : {
                            title: '',
                            key: ''
                        },
                        $arrowBox = $(BEMHTML.apply(_this.arrowBox(name, response.stations, base_station))),
                        arrowBox = $arrowBox.bem('arrow-box'),
                        $domElem;

                    // смотрим, есть ли попап для саггестов
                    if (input.domElem.length > 1) {

                        $domElem = $(input.domElem[0]);

                    } else {

                        $domElem = $(input.domElem);

                    }

                    $domElem.replaceWith($arrowBox);

                    _this[name] = arrowBox;

                    if (reset) {

                        arrowBox.setState(states[name]);

                    }

                });

            }
        });

    },

    arrowBox: function (name, stations, base_station) {
        key = base_station.key || 'empty';
        return {
            block: 'arrow-box',
            js: {name: name},
            mods: {type: 'native-select', direction: 'stations', bold: 'yes'},
            value: key,
            arrowOpt: [{
                name: '',
                value: 'empty',
                current: key === 'empty',
                disabled: true
            }].concat(stations.map(function (station) {
                return {
                    name: station.title,
                    value: station.point_key,
                    current: station.point_key == base_station.key,
                    disabled: !station.point_key
                };
            })),
            content: [
                name == 'from' && I18N('b-form', 'from-marker') || I18N('b-form', 'to-marker'),
                {
                    elem: 'selected',
                    content: base_station.title,
                    value: key
                }
            ]
        };

    },

    reset: function () {

        var directions = this.findBlockInside({block: 'arrow-box', modName: 'direction', modVal: 'list'}),
            allDays = this.findBlockInside('check-button');

        if (!!this.params.direction) {
            directions.setState({
                value: this.params.direction.code,
                name: this.params.direction.name
            });

            this.updateWidgets(this.params.direction.code, true);

        } else {
            this.updateWidgets(null, true);

            directions.setState({
                value: null,
                name: I18N('b-form', 'all-directions')
            });
        }

        this.setWhen();

        if (this.params.all_days) {
            allDays.setCheckedOn();

        } else {
            allDays.setCheckedOff();
        }
    },

    inputBlock: function (name) {

        var placeholders = {
            from: I18N('b-form', 'point-from-marker'),
            to: I18N('b-form', 'point-to-marker')
        };

        var mods = {suggest: 'yes', size: 'm', pick: 'yes', theme: 'destination'};

        if (name === 'to') {
            mods.margin = 'bottom';
        }

        return {
            block: 'input',
            mods: mods,
            js: {
                dataprovider:  {
                    name: 'dataprovider', field: name, suggestsType: 'suburban'
                },
                name: name
            },
            content: [
                {
                    elem: 'control',
                    attrs: {placeholder: placeholders[name], autocorrect: 'off', name: name + 'Name'}
                },
                {
                    elem: 'key',
                    tag: 'input',
                    attrs: {name: name + 'Id', type: 'hidden'}
                }
            ]
        };
    },

    buildUrl: function () {

        var arrowBoxes = this.findBlocksInside({block: 'arrow-box', modName: 'direction', modVal: 'stations'}),
            direction = this.findBlockInside({block: 'arrow-box', modName: 'direction', modVal: 'list'}),
            inputs = this.findBlocksInside('input'),
            when = this.elem('button'),
            allDays = this.findBlockInside('check-button'),
            fromName,
            fromId,
            toName,
            toId,
            stations = {},
            params;

        if (arrowBoxes.length) {

            $.each(arrowBoxes, function (i, arrowBox) {

                stations[arrowBox.params.name] = arrowBox.currentOptParams();

            });

            fromName = '';
            fromId = stations.from.value;

            toName = '';
            toId = stations.to.value;

        } else {

            $.each(inputs, function (i, input) {

                stations[input.params.name] = input;

            });

            fromName = stations.from.val();
            fromId = stations.from.keyVal();

            if (!!this.params.fromName && this.params.fromName != fromName && fromId == this.params.fromId) {

                fromId = '';

            }

            toName = stations.to.val();
            toId = stations.to.keyVal();

            if (!!this.params.toName && this.params.toName != toName && toId == this.params.toId) {

                toId = '';

            }

        }

        params = {
            fromName: fromName,
            fromId: fromId,
            toName: toName,
            toId: toId,
            direction: direction.currentOptParams().value || ''
        };

        if (!!this.params.city) {
            params.city = this.params.city;
        }

        var delta = this.when.data('delta');

        if (!allDays.isChecked()) {
            params.when = when.val();
            if (delta === 'all') {
                delta = 0;
            }
        } else {
            params.when = I18N('b-filters', 'any-days');
            params.all_days = '1';
            delta = 'all';
        }

        BEM.blocks['i-stat-counter'].reachGoal('SEARCH-ON-DAY', {delta: delta, type: 'suburban-direction'});

        return '/direction-search/?' + $.param(params);

    },

    isValid: function () {

        var inputs = this.findBlocksInside('input'),
            stations = {},
            stationFrom,
            stationTo;

        if (!inputs.length) {

            return true;

        }

        $.each(inputs, function (i, input) {

            stations[input.params.name] = input;

        });

        stationFrom = stations.from;
        stationTo = stations.to;

        return !!(stationFrom.val() || stationFrom.keyVal()) && !!(stationTo.val() || stationTo.keyVal());

    },

    submit: function (e) {
        e && e.preventDefault();

        if (this.isValid()) {
            window.location.href = this.buildUrl();
        }

    }

});

})();
