(function(){

var URL = BEM.blocks['i-url'];
BEM.DOM.decl('b-form', {

    onSetMod: {
        js: function () {
            var _this = this,
                inputs = {};

            $.each(this.findBlocksInside('input'), function (i, input) {
                inputs[this.name()] = this;
            });

            this.from = inputs.fromName;
            this.to = inputs.toName;
            this.when = this.findElem('button');

            var $checkedDay = $('.b-calendar__date-day_checked_yes');

            if ($checkedDay.length) {

                this.whenDay = $checkedDay.bem('b-calendar__date-day');

            } else {

                this.whenDay = null;

            }

            this.bindTo('switch', 'click', this.reverse);

            this.bindTo('button', 'click', function () {
                var $calendar = $('.b-calendar__date-day_checked_yes').parents('.b-calendar'),
                    $calendars = $('.b-calendar'),
                    currentSwitcher = $('.b-month-switcher_state_current').bem('b-month-switcher'),
                    currentCalendar = $('.b-calendar_state_current').bem('b-calendar'),
                    calendar,
                    idx,
                    allDays = _this.findBlockInside('check-button'),
                    $calendarButtons = $('.b-datepicker__submit');

                // если выбрали дату в прошлом, показываем каледарь на текущий месяц
                if ($calendar.length) {

                    calendar = $calendar.bem('b-calendar');

                    idx = $calendars.index($calendar);

                } else {

                    calendar = $calendars.first().bem('b-calendar');

                    idx = 0;

                }

                var switcherDiv = $('.b-month-switcher').get(idx);

                var switcher = $(switcherDiv).bem('b-month-switcher');

                if (!!allDays && allDays.isChecked()) {
                    return;
                }

                $calendarButtons.show();

                if (!_this.from.val() || !_this.to.val()) {
                    $calendarButtons.hide();
                }

                currentCalendar.setMod('state', 'hidden');

                calendar.setMod('state', 'current');

                currentSwitcher.setMod('state', 'hidden');

                switcher.setMod('state', 'current');

                switcher.setMod('state', 'current');

                BEM.blocks['b-content'].toggle();
            });

            this.bindTo('submit', this.submit);

            BEM.blocks.dataprovider.on('showSuggestFoot', function (e, link) {
                _this.from.link = link;
                _this.to.link = link;
            });

            BEM.blocks.dataprovider.on('hideSuggestFoot', function (e) {
                _this.from.link = null;
                _this.to.link = null;
            });
        }
    },

    getInputs: function () {
        var inputs = {};

        $.each(this.findBlocksInside('input'), function () {

            inputs[this.name()] = this;

        });

        return inputs;
    },

    reset: function () {
        var states = {
            from: {
                val: this.params.fromName,
                keyVal: this.params.fromId
            },
            to: {
                val: this.params.toName,
                keyVal: this.params.toId
            }
        };

        $.each(this.findBlocksInside('input'), function (i, input) {
            var name = input.params.name;

            input.setState(states[name]);
        });

        this.setWhen();

        $('.b-calendar__date-day').removeClass('b-calendar__date-day_checked_yes');

        if (this.whenDay !== null) {

            var $when = $(this.whenDay.domElem);

            $when.addClass('b-calendar__date-day_checked_yes');
        }
    },

    setWhen: function (day, delta) {
        var params = this.params;

        if (arguments.length != 2) {
            day = params.when;
            delta = params.delta;
        }

        var whenButton = this.elem('button');

        var icon = BEMHTML.apply([
            day,
            {
                block: this.__self._name,
                elem: 'button-icon'
            }
        ]);

        var $whenButton = $(whenButton);

        whenButton.val(day);

        $whenButton.attr('value', day);
        this.when.data('delta', delta);

        BEM.DOM.update(whenButton, icon);
    },

    reverse: function () {
        var fromState = this.from.getState();

        this.from.setState(this.to.getState());
        this.to.setState(fromState);
    },

    checkFields: function () {
        if (!this.from.val() || !this.to.val()) {
            if (!this.from.val()) {
                this.from.setMod('focused', 'yes');
            }
            if (!this.to.val()) {
                if (!this.from.hasMod('focused')) {
                    this.to.setMod('focused', 'yes');
                }
            }

            return false;
        }

        return true;
    },

    buildUrl: function () {
        var _this = this,
            fromKey = _this.from.findElem('key'),
            toKey = _this.to.findElem('key');

        var when = this.when.val();

        if (!when) {
            when = this.params.when || this.params.defaultWhen;
        }

        var params = {
            fromName: _this.from.val(),
            toName: _this.to.val(),
            when: when
        };

        if (!!this.params.fromName && this.params.fromName != this.from.val() && this.params.fromId == fromKey.val()) {
            params.fromId = '';
        } else {
            params.fromId = fromKey.val();
        }

        if (!!this.params.toName && this.params.toName != this.to.val() && this.params.toId == toKey.val()) {
            params.toId = '';
        } else {
            params.toId = toKey.val();
        }

        // Хак для передачи языка в сабмиты форм
        var lang = URL.parseQuery(document.location.search, true).lang;
        if (lang) {
            params.lang = lang[0]; // Т.к lang это массив =(
        }

        return '/search/?' + $.param(params);
    },

    submit: function (e) {
        e && e.preventDefault();

        if (this.checkFields()) {

            var deltaWhen = this.when.data('delta');

            BEM.blocks['i-stat-counter'].reachGoal('SEARCH-ON-DAY', {delta: deltaWhen});

            window.location = this.buildUrl();

        }

        return true;
    }
});

})();
