(function () {
var iLocation = BEM.blocks['i-location'];

BEM.DOM.decl({block: 'b-page', modName: 'type', modValue: 'schedule'}, {

    onSetMod: {

        js: function () {
            var routers = this.routers = this.findBlockInside({
                block: 'b-routers',
                modName:'type',
                modVal:'for-scoreboard'
            });
            this.routeFilter = this.findBlockInside({
                block: 'input',
                modName:'filter',
                modVal:'yes'
            });
            this.terminals = this.findBlockInside({
                block: 'arrow-box',
                modName:'filter',
                modVal:'terminals'
            });

            this.showMore = this.findBlockInside({
                block: 'b-action-button',
                modName:'type',
                modVal:'more'
            });

            this.timeSwitcher = this.findBlockInside('b-time-switcher');

            if (this.routeFilter) {
                this.routeFilter.on('filter-change', function (e, query) {
                    routers.changeQuery(query);
                }.bind(this));
            }

            if (this.terminals) {
                this.terminals.on('onChange', function () {
                    var terminalValue = this.terminals.val();
                    routers.changeTerminal(terminalValue);
                    iLocation.rewrite({
                        terminal: terminalValue
                    });
                }.bind(this));
            }

            if (this.timeSwitcher) {
                this.timeSwitcher.on('change', function (e, interval) {
                    routers.changeInterval(interval);
                });
            }

            if (this.showMore) {
                routers.on('update', function (e, $lines) {
                    if ($lines.length > routers.getScheduleAmount()) {
                        this.showMore.show();
                    } else {
                        this.showMore.hide();
                    }
                }.bind(this));

                this.showMore.bindTo('click', function () {
                    if (routers.showNextPage()) {
                        this.showMore.hide();
                    }
                }.bind(this));
            }
        }
    }
});
}());

