BEM.DOM.decl('b-radio-group', {

    onSetMod: {

        js: function () {
            this._name = this.params.name;
        }

    },

    val: function (name) {
        if (typeof name === 'undefined') {
            return {
                name: this._name,
                data: this.elemParams(this.itemByName(this._name)).data
            };
        }
        if (name === this._name) {
            return;
        }

        var prev = this.itemByName(this._name),
            next = this.itemByName(name);

        this.delMod(prev, 'checked')
            .setMod(next, 'checked', 'yes');

        this._name = name;

        this.trigger('change', this.val());

        return this;
    },
    itemByName: function (name) {
        return this.elem('item', 'name', name);
    }
}, {
    live: function () {
        this.liveBindTo('item', 'click', function (e) {
            e.preventDefault();
            var name = this.getMod(e.data.domElem, 'name');
            this.val(name);
        });
    }
});
