(function () {
var AJAX = BEM.blocks['i-ajax'],
    DOM = BEM.DOM;

DOM.decl({name: 'b-routers', modName: 'ajax', modVal: 'yes'}, {
    onSetMod: {
        js: function () {
            this.__base.apply(this, arguments);

            var _this = this,
                info = _this.params.ajax_info,
                params,
                searchType = _this.params.search_type;

            if (!info) {
                return;
            }

            params = {
                d: info.d,
                k: info.k,
                ts: info.ts,
                r: info.r,
                ttype: searchType
            };

            if (info.b) {
                params.b = info.b;
            }

            AJAX.progress(function (finish) {
                $.ajax({
                    url: _this.params['update-url'],
                    data: JSON.stringify(params),
                    contentType: 'application/json',
                    timeout: 5000,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (_this.ajaxUpdate(info, response)) {
                            finish();
                        }
                    }
                });
            }, function () {
                _this.removeSpinners();
                var blablacarLines = _this.blablacarLines;
                if (blablacarLines) {
                    blablacarLines.toArray().forEach(function (line) {
                        var $line = $(line);
                        var blablacar = _this.findBlockInside($line, 'b-blablacar');
                        if (blablacar.getMod('loading') === 'success') {
                            return;
                        }

                        blablacar.hide();
                        $line.hide();
                    });
                }

                var lines = _this.findElem('line');

                if (!lines.length) {

                    DOM.update($(_this.domElem), BEMHTML.apply({
                        block: 'b-message',
                        mods: {type: 'null-search-result'},
                        content: {
                            elem: 'item',
                            content: _this.params.not_found_message
                        }
                    }));
                }
            }, {
                tries: 4 // больше 20 секунд ждать не имеет смысла
            });
        }
    },

    removeSpinners: function () {
        this.domElem.find(BEM.blocks['b-spin'].buildSelector('progress', 'yes')).remove();
    },

    ajaxUpdate: function (info, response) {
        var newLines = [],
            $sortingBlock = $('.arrow-box_sort_yes'),
            newData = {},
            sortingBlock,
            sortParam = 'departure';

        $.each(response.lines, function (i, bemjson) {
            var $line = $(BEMHTML.apply(bemjson)),
                params = this.elemParams($line),
                key = params.key,
                line = $line[0];

            newData[key] = line;
            newLines.push(line);

            DOM.init($line);
        }.bind(this));

        this.lines = this.lines.filter(function (line) {
            var params = this.elemParams($(line)),
                key = params.key;

            if (key in newData) {
                $(this.data[key]).remove();
                return false;
            }

            return true;
        }.bind(this));

        $.extend(this.data, newData);

        Array.prototype.push.apply(this.lines, newLines);

        $.each(response.updates, function (key, update) {
            var html = BEMHTML.apply(update.places),
                line = this.data[key],
                item = this.findElem($(line), 'item', 'type', 'last-column'),
                elemBlock;

            DOM.update(item, html);

            var descr = this.findElem($(line), 'number-transport');

            if (update.eticket) {
                this.setMod(descr, 'type', 'ticket-ico');
            }

            if (!!line){
                elemBlock = $(line).bem('b-routers__line');
                elemBlock.params.tickets = update.places_names;
            }
        }.bind(this));

        if (response.specialLines.blablacar.length) {
            this.updateBlablacar(response.specialLines.blablacar[0]);
        }

        if ($sortingBlock.length) {

            sortingBlock = $sortingBlock.bem('arrow-box');
            sortParam = sortingBlock.currentValue;

        }

        this.sort(sortParam);
        this.updateLines();
        this.addDepartureFlags();

        info.ts = response.ts;

        info.k = $.map(info.k, function (d) {
            return $.inArray(d, response.complete) === -1 ? d : null;
        });

        return info.k.length === 0;
    }

});

})();
