(function () {

var DOM = BEM.DOM,
    GLOBAL = BEM.blocks['i-global'];

DOM.decl({name: 'b-routers', modName: 'type', modVal: 'for-scoreboard'}, {
    onSetMod: {

        js: function () {
            this.__base.apply(this, arguments);
            this.$errorMessage = $('.error-message');

            // максимальные даты по поиску с запросом
            this.minDate = this.params.minDate;
            this.maxDate = this.params.maxDate;

            // текущее окно табло
            this.queryStartDate = this.startDate = this.params.startDate;
            this.queryEndDate = this.endDate = this.params.endDate;
            this.event = this.params.event;
            this.query = '';
            this.terminal = this.params.terminal || null;
            this.page = 0;
            this.hasPaging = !!this.params['schedule-amount'];
        }

    },

    changeQuery: function (query) {
        this.query = query;

        if (query) {
            this.queryStartDate = this.minDate;
            this.queryEndDate = this.maxDate;
        } else {
            this.queryStartDate = this.params.startDate;
            this.queryEndDate = this.params.endDate;
        }

        return this.ajaxUpdate();
    },

    changeTerminal: function (terminal) {
        this.terminal = terminal;

        return this.ajaxUpdate();
    },

    changeInterval: function (newInterval) {
        this.startDate = this.queryStartDate = newInterval.start;
        this.endDate = this.queryEndDate = newInterval.end;

        return this.ajaxUpdate();
    },

    fetchNewLines: function () {
        this.$errorMessage.addClass('i-hidden');
        if (this.changeRequest) {
            this.changeRequest.abort();
            this.changeRequest = null;
        }

        this.setMod('fog', 'shown');
        this.changeRequest = $.ajax({
            url: this.params['update-url'],
            data: {
                start: this.queryStartDate,
                end: this.queryEndDate,
                query: this.query,
                event: this.event,
                terminal: this.terminal,
                direction: this.params.direction
            },
            contentType: 'application/json',
            dataType: 'json'
        });

        return this.changeRequest.then(function (data) {
            this.delMod('fog');
            if (!data.lines.length) {
                this.$errorMessage.html(BEMHTML.apply({
                    block: 'b-message',
                    mods: {type: 'null-search-result'},
                    content: [
                        {
                            elem: 'item',
                            content: I18N('b-routers', 'routes-not-found')
                        }
                    ]
                })).removeClass('i-hidden');
            }

            var lineBuilder = this.getLineBuilder();
            var newRoutes = data.lines.map(lineBuilder.bind(this, this.params.ttype));

            return $(BEMHTML.apply(newRoutes));
        }.bind(this), function () {
            this.delMod('fog');
        }.bind(this));
    },

    getLineBuilder: function () {
        if (this.params.scheduleType === 'tablo') {
            return build_tablo_schedule_route;
        } else {
            if (this.params.scheduleType === 'train') {
                return build_train_schedule_route;
            }
        }

        return build_other_schedule_route;
    },

    getScheduleAmount: function () {
        return this.params['schedule-amount'];
    },

    showNextPage: function () {
        this.page++;
        var amount = this.params['schedule-amount'];

        var lines = this.findElem('line');

        var leftBorder = amount * this.page;
        var rightBorder = leftBorder + amount;

        var pageLines = lines.slice(leftBorder, rightBorder);

        $.each(pageLines, function (i, line) {
            var $line = $(line);

            $line.removeClass('i-hidden hidden-page');
        });

        return rightBorder >= lines.length;
    },

    ajaxUpdate: function () {
        this.fetchNewLines().then(function ($domElem) {
            this.elem('body').html($domElem);
            return $domElem;
        }.bind(this)).then(function ($domElem) {
            this.page = 0;
            this.trigger('update', $domElem);
        }.bind(this));
    }
});

// ждем перехода на bh, так как на bemhtml - не хочется такую логику писать
function build_tablo_schedule_route(stationType, route, index) {
    var ttype = route.ttype;

    return buildLine(route, [
            {
                elem: 'item',
                content: [
                    {
                        elem: 'time',
                        elemMods: {type: stationType === 'plane' && 'arrival' || 'departure'},
                        content: route.scheduled
                    },
                    {
                        elem: 'time',
                        elemMods: {type: 'departure'},
                        content: route.actual
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: stationType === 'plane' && 'route-picture' || 'gap'},
                content: stationType === 'plane' && buildIcon(route.companyIcon)
            },
            {
                elem: 'item',
                elemMods: {type: 'route'},
                content: [
                    info(route, ttype),
                    {
                        block: 'b-link',
                        url: route.threadUrl,
                        js: {url: route.threadUrl},
                        content: {
                            elem: 'item',
                            content: route.title
                        }
                    },
                    stationType === 'plane' && {
                        elem: 'terminal',
                        mix: {block: 'b-routers', elem: 'time', elemMods: {type: 'in-path'}},
                        content:[
                            route.model,
                            route.terminal
                        ]
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: 'last-column'},
                content: buildStatus(route)
            }
        ], index);
}

function build_other_schedule_route(stationType, route, index) {
    var expressContent;

    if (route.expressTitle && route.expressColor) {
        expressContent = {
            elem: 'span',
            tag: 'span',
            attrs: {style: 'color: ' + route.expressColor},
            content: route.expressTitle
        };
    }

    return buildLine(route, [
            {
                elem: 'item',
                elemMods: {type: 'flag'},
                content: route.departure_left
            },
            {
                elem: 'item',
                content: [
                    {
                        elem: 'time',
                        elemMods: {type: 'departure'},
                        content: route.departure
                    },
                    route.platform && {
                        elem: 'platform',
                        content: route.platform
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: 'gap'},
                content: {
                    block: 'gap',
                    attrs: {style: 'margin: 0 6px 0 10px;'}
                }
            },
            {
                elem: 'item',
                elemMods: {type: 'route'},
                content: [
                    info(route, route.ttype),
                    {
                        block: 'b-link',
                        js: {
                            url: route.threadUrl
                        },
                        url: route.threadUrl,
                        content: [{
                            elem: 'item', content: build_title(route)
                        }, {
                            block: 'b-routers',
                            elem: 'time',
                            js: true,
                            elemMods: {type: 'in-path', 'with-indicator': 'yes'},
                            content: route.timeText
                        }]
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: 'last-column'},
                content: expressContent
            }
        ], index, true);
}

function build_train_schedule_route(stationType, route, index) {
    return buildLine(route, [
            {
                elem: 'item',
                content: [
                    {
                        elem: 'time',
                        elemMods: {type: 'departure'},
                        content: route.departure
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: 'gap'},
                content: {
                    block: 'gap',
                    attrs: {style: 'margin: 0 6px 0 10px;'}
                }
            },
            {
                elem: 'item',
                elemMods: {type: 'route'},
                content: [
                    info(route, route.ttype),
                    {
                        block: 'b-link',
                        js: {
                            url: route.threadUrl
                        },
                        url: route.threadUrl,
                        content: [{
                            elem: 'item', content: route.title
                        }, route.timeText && {
                            block: 'b-routers',
                            elem: 'time',
                            js: true,
                            elemMods: {type: 'in-path', 'with-indicator': 'yes'},
                            content: route.timeText
                        }]
                    }
                ]
            },
            {
                elem: 'item',
                elemMods: {type: 'last-column'}
            }
        ], index);
}

function build_title(route) {
    if (!route.subTitle) {
        return route.title;
    }

    return [route.title, ' ', {
        tag: 'span',
        block: 'b-routers',
        elem: 'time',
        elemMods: {
            type: 'in-path'
        },
        content: route.subTitle
    }];
}

function buildLine(route, content, index, haveFlag) {
    var mix = [],
        mods = {};

    if (this.hasPaging &&  index >= this.params['schedule-amount']) {
        mix = [{block:'i-hidden'}, {block: 'hidden-page'}];
    }

    if (!route.threadUrl) {
        mods.type = 'pop';
    }

    return {
        block: 'b-routers',
        elem: 'line',
        mix: mix,
        mods: mods,
        js: {is_extra: !route.threadUrl},
        elemMods: haveFlag && {'have-flag': 'yes'},
        content: content
    };
}

var knownStatuses = {
    real: {key: 'wait-scoreboard-status'},
    wait: {key: 'wait-scoreboard-status'},
    departure: {key: 'departure-scoreboard-status', level: 'green', isAttention: true},
    arrive: {key: 'arrival-scoreboard-status', level: 'green', isAttention: true},
    cancelled: {key: 'canceled-scoreboard-status', level: 'orange', isAttention: true},
    late: {key: 'delay-scoreboard-status', isAttention: true},
    nodata: {key: 'no-data-scoreboard-status', level: 'orange'}
};

function buildStatus(route) {
    var statusCode = route.status_code;

    if (!knownStatuses.hasOwnProperty(statusCode)) {
        return;
    }
    var statusModel = knownStatuses[statusCode];
    var statusBemJson = {
        elem: statusModel.isAttention && 'attention',
        elemMods: statusModel.level && {color: statusModel.level},
        content: I18N('b-routers', statusModel.key)
    };

    if (statusCode === 'late') {
        statusBemJson = [statusBemJson, {
            block: 'b-routers',
            elem: 'time',
            elemMods: {type: 'delay'},
            content: route.delay
        }];
    }

    return statusBemJson;
}

function info(route, tcode) {
    var content = [{
        block: 'b-icon-carrier',
        mods: {
            type: tcode
        }
    }];

    var tabloName = [{
        elem: 'number-transport',
        content: route.number
    }];

    if (route.company) {
        tabloName = tabloName.concat([' ', {
            elem: 'company',
            content: route.company
        }]);
    }

    if (GLOBAL.param['national-version'] === 'tr' && tcode === 'train') {
        tabloName.reverse();
    }

    return {
        elem: 'info',
        content: content.concat(tabloName, extraInfo(route))
    };
}

function extraInfo(route) {
    if (route.throughTrain) {
        return [
            '&nbsp;', {
                elem: 'span',
                content: route.throughTrain
            }
        ];
    }

    if (route.titleSpecial) {
        return [
            '&nbsp;', {
                elem: 'title-special',
                content: route.titleSpecial
            }
        ];
    }

    if (route.deluxe) {
        return [
            '&nbsp;', {
                elem: 'title-special',
                content: route.deluxe
            }
        ];
    }

    return [];
}

function buildIcon(companyIcon) {
    var icons = [];

    if (companyIcon.pngUrl) {
        icons.push({
            block: 'b-icon',
            mods: {type: 'aviacompany', format: 'png'},
            src: companyIcon.pngUrl,
            width: 18
        });
    }

    if (companyIcon.svgUrl) {
        icons.push({
            block: 'b-icon',
            mods: {type: 'aviacompany', format: 'svg'},
            src: companyIcon.svgUrl,
            width: 18
        });
    }

    if (icons.length === 1) {
        icons[0].mods['force-show'] = 'yes';
    }

    return icons;
}
}());
