(function() {

var AJAX = BEM.blocks['i-ajax'],
    DOM = BEM.DOM;

DOM.decl({name: 'b-routers', modName: 'type', modVal: 'timetable'}, {

    onSetMod: {

        'js': function () {

            var _this = this;

            this.lines = $.makeArray(this.findElem('line'));

            this.data = {};

            $.each(_this.lines, function(i, line) {

                var params = _this.elemParams($(line));

                _this.data[params.key] = line;

            });

            _this.sort();
            _this.updateLines();
            _this.addDepartureFlags();

            this.bindTo('line', 'click', function (e) {

                var isExtra = _this.elemParams(e.data.domElem).is_extra;

                if (!isExtra) {

                    window.location = $(e.data.domElem).find('a').attr('href');

                }

            });
        }
    },

    updateLines: function() {

        var _this = this;

        $(_this.lines).remove();

        var table = $(_this.findElem('body'));

        $.each($(_this.lines), function(i, line) {

            table.append(line);

        });

    },

    sort: function() {

        var _this = this;

        _this.lines.sort(function(lineA, lineB) {

            var paramsA = _this.elemParams($(lineA)),
                paramsB = _this.elemParams($(lineB)),
                departureA = Date.parse(paramsA.departure),
                departureB = Date.parse(paramsB.departure);

            if (departureA < departureB) {

                return -1;

            }

            if (departureA > departureB) {

                return 1;

            }

            return 0;

        });

    },

    addDepartureFlags: function() {

        var _this = this,
            lines = $.makeArray(_this.findElem('line')).filter(function(line) {

                var lineBlock = $(line).bem('b-routers__line'),
                    params = lineBlock.params;

                return !params.gone;

            }).splice(0, 3);

        $.each(_this.lines, function(i, line) {

            var flagColl = _this.findElem($(line), 'item', 'type', 'flag');

            $(line).bem('b-routers__line').delMod('have-flag');

            $(flagColl).html('');

        });

        $.each(lines, function(i, line) {

            var flagColl = _this.findElem($(line), 'item', 'type', 'flag'),
                params = _this.elemParams($(line)),
                html = BEMHTML.apply({
                    block: 'b-routers',
                    elem: 'flag',
                    content: {
                        elem: 'time',
                        elemMods: {type: 'before-departure-left'},
                        content: params.time_to_departure
                    }
                });

            BEM.DOM.update(flagColl, $(html));

            $(line).bem('b-routers__line').setMod('have-flag', 'yes');

        });

    }

});

})();