(function () {

function dateTimeCleaner(s) {

    return new Date(s.replace(/(\d+)-(\d+)-(\d+)/, '$2/$3/$1'));

}

function timeCleaner(s) {

    var date = dateTimeCleaner(s);

    date.setFullYear(2000, 1, 1);

    return date.getTime();

}

var CLEANERS = {
    departure: dateTimeCleaner,
    arrival: dateTimeCleaner,
    price: function (s) {

        if (!s) {

            return Infinity;

        }

        return parseFloat(s);

    },
    travel_time: function (s) {

        if (!s) {

            return Infinity;

        }

        return parseInt(s);

    }
};

BEM.DOM.decl('b-routers', {

    onSetMod: {

        js: function () {
            this.__base.call(this, arguments);

            var _this = this;

            $('.b-preloader').hide();

            var $lines = $(this.findElem('line'))
                .not('.b-routers__line_type_head-line')
                .not('.b-routers__line_type_blablacar');

            this.blablacarLines = this.elem('line', 'type', 'blablacar');

            this.lines = $.makeArray($lines);

            this.data = {};

            $.each(this.lines, function (i, line) {

                var params = _this.elemParams($(line));

                _this.data[params.key] = line;

            });

            if (!this.hasMod('suburban') &&
                !this.hasMod('search-threads') &&
                this.getMod('type') !== 'for-scoreboard' &&
                this.getMod('type') !== 'search-result' &&
                this.getMod('type') !== 'schedule' &&
                this.getMod('type') !== 'search-number-trip') {

                this.sort();
                this.updateLines();
                this.addDepartureFlags();
                this.repositeBlablacar();

            }

            if (this.hasMod('suburban') && !this.params.all_days) {

                this.addDepartureFlags();

            }

            this.domElem.delegate('.b-routers__line', 'click tap', this.handleLineClick.bind(this));
            this.domElem.delegate('.b-routers__button', 'click tap', function (e) {
                e.stopPropagation();
                BEM.blocks['i-stat-counter'].reachGoal('REDIRECT_TO_AVIA_FROM_SEARCH');
            });
            this.domElem.delegate('.b-routers__item_type_last-column', 'click', function (searchType, e) {
                if ($(e.currentTarget).text()) {
                    BEM.blocks['i-stat-counter'].reachGoal('WANT-BUY-TICKET-ON-SEARCH-PAGE', {ttype: searchType});
                }
            }.bind(null, this.params.search_type));
        }
    },

    numRows: function (elem) {

        var $domElem = $(elem),
            fontSize = parseInt($domElem.css('font-size')),
            rowHeight = Math.floor(fontSize * 1.2),
            height = $domElem.height();

        if (!height) {

            return 0;

        }

        return Math.floor(height / rowHeight);

    },

    handleLineClick: function (e) {
        var $line = $(e.currentTarget);

        if (this.getMod($line, 'type') === 'head-line') {
            return;
        }

        if (this.getMod($line, 'type') === 'blablacar') {
            var blablacar = this.findBlockInside($line, 'b-blablacar');
            if (blablacar && blablacar.params.data.url) {
                window.location = blablacar.params.data.url;
            }

            return;
        }

        var params = this.elemParams($line),
            isExtra = params.is_extra,
            url = $line.find('a').attr('href');

        BEM.blocks['i-stat-counter'].reachGoal('GO-TO-VIEW-THREAD', {
            extra: !!isExtra
        });

        if (!isExtra && !!url) {
            window.location = url;
        }
    },

    updateLines: function () {

        var table = $(this.findElem('body')),
            $lines = $(this.findElem('line'))
                .not('.b-routers__line_type_head-line')
                .not('.b-routers__line_type_blablacar');

        $lines.remove();

        var showedLinesCount = 0;
        var showedBlablacar = false;

        this.lines.forEach(function (line) {
            table.append(line);

            if (!$(line).hasClass('i-hidden')) {
                showedLinesCount++;
            }

            if (showedLinesCount === 2) {
                table.append(this.blablacarLines);
                showedBlablacar = true;
            }
        }.bind(this));

        if (!showedBlablacar && this.lines.length) {
            table.append(this.blablacarLines);
        }
    },

    doSort: function (cleaner, param) {

        var _this = this;

        this.lines.sort(function (lineA, lineB) {

            var paramsA = _this.elemParams($(lineA)),
                paramsB = _this.elemParams($(lineB));

            var    sortValueA = cleaner(paramsA[param]),
                sortValueB = cleaner(paramsB[param]);

            if (sortValueA < sortValueB) {

                return -1;

            }

            if (sortValueA > sortValueB) {

                return 1;

            }

            if (paramsA.id || paramsB.id) {
                if (paramsA.id < paramsB.id) {
                    return -1;
                }

                if (paramsA.id > paramsB.id) {
                    return 1;
                }
            }

            return 0;

        });

    },

    sort: function (param) {

        var cleaner;

        if (!param) {

            param = 'departure';

        }

        if (!!this.params.all_days && ['arrival', 'departure'].indexOf(param) > -1) {

            cleaner = timeCleaner;

        } else {

            cleaner = CLEANERS[param];

        }

        this.doSort(cleaner, param);

    },

    addDepartureFlags: function () {

        var _this = this,
            lines = $.makeArray(_this.findElem('line')).filter(function (line) {
                var lineBlock = $(line).bem('b-routers__line'),
                    params = lineBlock.params;

                return !params.gone;
            }).splice(0, 5);

        $.each(_this.lines, function (i, line) {

            var flagColl = _this.findElem($(line), 'item', 'type', 'flag');

            $(line).bem('b-routers__line').delMod('have-flag');

            $(flagColl).html('');

        });

        $.each(lines, function (i, line) {

            var flagColl = _this.findElem($(line), 'item', 'type', 'flag'),
                lineBlock = $(line).bem('b-routers__line'),
                params = lineBlock.params,
                html = BEMHTML.apply({
                    block: 'b-routers',
                    elem: 'flag',
                    content: {
                        elem: 'time',
                        elemMods: {type: 'before-departure-left'},
                        content: params.time_to_departure
                    }
                });

            if (!!params.time_to_departure) {

                BEM.DOM.update(flagColl, $(html));

                $(line).bem('b-routers__line').setMod('have-flag', 'yes');

            }

        });
    },
    updateBlablacar: function (bemjson) {
        if (this.blablacarLines) {
            this.blablacarLines.remove();
        }

        this.blablacarLines = BEM.DOM.init($(BEMHTML.apply(bemjson)));
    },

    repositeBlablacar: function () {
        if (!this.blablacarLines) {
            return;
        }
        var $lines = this.findElem('line')
            .not('.b-routers__line_type_head-line')
            .not('.b-routers__line_type_blablacar');

        var showedLinesCount = 0;
        var $beforeThis = null;
        for (var i = 0 ; i < $lines.length; i++) {
            var $line = $($lines[i]);

            if (!$line.hasClass('i-hidden')) {
                showedLinesCount++;
            }

            if (showedLinesCount === 2) {
                $beforeThis = $line;
                break;
            }
        }

        if (!$beforeThis && $lines.length) {
            $beforeThis = $($lines[$lines.length - 1]);
        }

        this.blablacarLines.detach();

        if ($beforeThis) {
            this.blablacarLines.insertAfter($beforeThis);
        }
    }
});

})();
