BEM.DOM.decl('b-sideslide', {

    onSetMod: {
        js: function () {
            this.hide();
        },
        state: {

            expanded: function () {

                this.show();

            },

            '': function () {

                this.hide();

            }

        }

    },

    toggleState: function () {

        var ua = BEM.blocks['i-ua'];

        // скроллим меню где это возможно
        if (ua.wp || ua.ios > '5' || (ua.android > '4' && !ua.opera)) {
            $(document.documentElement).toggleClass('b-sideslide_scroll_yes');
        }

        this.toggleMod('state', 'expanded');

    },

    show: function () {

        var that = this;
        this.__wp = BEM.blocks['i-ua'].wp ||
            (BEM.blocks['i-ua'].other && BEM.blocks['i-ua'].ua.indexOf('Windows') > -1);

        this
            .setMod(this.elem('menu'), 'visibility', 'visible')
            .setMod(this.elem('content'), 'visibility', 'hidden');

        if (this.__wp) {
            this.correctHeight();
        } else {
            this.elem('content').one('webkitTransitionEnd oTransitionEnd otransitionend', function () {
                that.trigger('open');
                that.correctHeight();
            });
        }

        this.bindToWin('orientchange', this.correctHeight);
        this.trigger('show');
    },

    hide: function () {

        var that = this;

        this.delMod(this.elem('content'), 'visibility');
        this.delMod(that.elem('menu'), 'visibility');

        if (this.__wp) {
            this
                .delMod(that.elem('menu'), 'visibility')
                .elem('inner').height('auto');
        } else {
            this.elem('content').one('webkitTransitionEnd oTransitionEnd', function () {
                that
                    .trigger('close')
                    .elem('inner').height('auto');
            });
        }

        this.unbindFromWin('orientchange', this.correctHeight);
        this.trigger('hide');
    },

    correctHeight: function () {

        var inner = this.elem('inner'),
            west = this.elem('menu'),
            ua = BEM.blocks['i-ua'];

        if (west.height() < window.innerHeight) {
            inner.height(window.innerHeight);
        } else {
            inner.height(west.height());
        }

        // задаем высоту по высоте видимой области, чтобы скроллить в этих пределах
        if (this.__wp || ua.ios > '5' || (ua.android > '4' && !ua.opera)) {
            west.height(window.innerHeight);
        }
    }

}, {

    live: function () {

        this.liveBindTo('switcher fake-switcher', 'click tap', function () {
            this.toggleState();
        });

    }

});
