(function () {

BEM.DOM.decl({name: 'b-switcher', modName: 'type', modVal: 'station-filter'}, {
    _onChange: function (filterType) {
        var $routers = this.$routers || (this.$routers = $('.b-routers')),
            $titles = this.$titles || (this.$titles = $('.b-title'));

        if (filterType === 'all') {
            $routers.removeClass('i-hidden');
            $titles.removeClass('i-hidden');
            return;
        }

        toggleBlocksByMod($titles, 'b-title', 'filter', filterType);
        toggleBlocksByMod($routers, 'b-routers', 'filter', filterType);
    }
});

function toggleBlocksByMod($blocks, blockName, modName, modValue) {
    $blocks.each(function () {
        var $this = $(this);
        if ($this.hasClass(blockName + '_' + modName + '_' + modValue)) {
            $this.removeClass('i-hidden');
        } else {
            $this.addClass('i-hidden');
        }
    });
}

})();
