(function (BEM, undefined) {

    var iLocation = BEM.blocks['i-location'];

    BEM.DOM.decl('b-switcher', /** @lends block.prototype */ {
        onSetMod: {
            js: function () {
                this._val = this.params.value;
            }
        },

        val: function (val) {
            if (typeof val === 'undefined') {
                return this._val;
            }

            if (val === this._val) {
                return this;
            }

            var $prevCheckedButton = this.elem('button', 'checked', 'yes');

            var $buttons = this.elem('button'),
                $newCheckedButton;

            for (var i = 0; i < $buttons.length; i++) {
                var $button = $($buttons[i]);
                if (this.elemParams($button).value === val) {
                    $newCheckedButton = $button;
                    break;
                }
            }

            this.delMod($prevCheckedButton, 'checked', 'yes')
                .setMod($newCheckedButton, 'checked', 'yes');

            this._val = val;

            this.trigger('change');

            this._onChange(val, $newCheckedButton);

            return this;

        },

        reset: function () {
            this.val(this.params.value);
        },

        _onChange: function (value) {
            var params = {};
            params[this.params.paramName] = value;

            window.location.href = iLocation
                .getUrl()
                .setParams(params)
                .render();
        }
    }, {
        live: function () {
            this.liveBindTo('button', 'click', function (e) {
                var value = this.elemParams(e.data.domElem).value;

                this.val(value);
            });
        }
    });
})(BEM);
