(function () {
    BEM.DOM.decl('b-time-switcher', {
        onSetMod: {
            js: function () {
                var self = this;
                var items = this.findElem('item');
                var currentItem = this.findElem('item', 'checked', 'yes');
                var nextItem = this.getNextItem(currentItem);
                if (nextItem !== null) {
                    this.setMod($(nextItem), 'checked', 'yes');
                }

                this.bindTo('item', 'click', function (e) {
                    var params = self.elemParams($(e.data.domElem)),
                        switcher = $('.b-switcher_switch_events'),
                        $currentItem = $(e.data.domElem),
                        $nextItem = $(self.getNextItem($currentItem));

                    self.delMod(items, 'checked');
                    self.setMod($nextItem, 'checked', 'yes');
                    self.setMod($currentItem, 'checked', 'yes');

                    if (switcher.length) {
                        switcher = switcher.bem('b-switcher');
                    } else {
                        switcher = null;
                    }

                    this.trigger('change', {
                        start: params.start,
                        end: params.end
                    });
                });
            }

        },

        getNextItem: function (item) {
            var items = this.findElem('item'),
                index = items.index(item);

            if (index === items.length - 1) {
                return null;
            }

            return items.get(index + 1);
        }
    });
})();

var myScroll;

function loaded() {
    if ($('#wrapper').length) {
        myScroll = new iScroll('wrapper', {
            snap: false,
            momentum: true,
            hScrollbar: true,
            vScroll: false,
            scrollbarClass: 'b-time-switcher__scrollbar',
            hideScrollbar: false
        });

        myScroll.scrollToElement('.b-time-switcher__item_checked_yes');
    }
}

document.addEventListener('DOMContentLoaded', loaded, false);
