(function () {

var AJAX = BEM.blocks['i-ajax'],
    DOM = BEM.DOM;

BEM.DOM.decl({block: 'b-transport', modName: 'ajax', modVal: 'yes'}, {

    onSetMod: {
        js: function () {
            this.__base.apply(this, arguments);

            var _this = this,
                info = _this.params.ajax_info,
                params,
                ttypes = ['plane', 'bus', 'train'],
                lines = _this.findElem('line');

            this.tariffs = {};
            this.counts = {};
            this.lines = {};
            this.durations = {};

            $.each(lines, function (i, line) {

                var params = _this.elemParams($(line)),
                    ttype = params.ttype;

                if ($.inArray(ttype, ttypes) === -1) {

                    return;

                }

                _this.counts[ttype] = params.count;
                _this.durations[ttype] = params['min-duration'];
                _this.tariffs[ttype] = params['min-tariff'];

                _this.lines[ttype] = line;

            });

            if (info === undefined) {
                $('.b-preloader').hide();

                return;
            }

            params = {
                durations: _this.durations,
                tariffs: _this.tariffs,
                counts: _this.counts,
                d: info.d,
                k: info.k,
                ts: info.ts,
                r: info.r,
                when: _this.params.when
            };

            if (info.b) {
                params.b = info.b;
            }

            AJAX.progress(function (finish) {
                $.ajax({
                    url: _this.params['update-url'],
                    data: JSON.stringify(params),
                    dataType: 'json',
                    timeout: 5000,
                    contentType: 'application/json',
                    type: 'POST',
                    success: function (response) {
                        if (_this.ajaxUpdate(info, response)) {
                            finish();
                        }

                        $('.b-preloader').hide();
                    }
                });

            }, function () {
                $('.b-preloader').hide();

                var lines = _this.findElem('line');

                if (!lines.length) {
                    DOM.update($(_this.domElem), BEMHTML.apply({
                        block: 'b-message',
                        mods: {type: 'null-search-result'},
                        content: {
                            elem: 'item',
                            content: _this.params.not_found_message
                        }
                    }));
                }
            }, {
                retries: 4 // больше 20 секунд ждать не имеет смысла
            });
        }
    },

    ajaxUpdate: function (info, response) {
        var _this = this,
            data = response.data;

        $.each(data, function (ttype, data) {

            // обновляем модель
            _this.tariffs[ttype] = data['min-tariff'];
            _this.durations[ttype] = data['min-duration'];

            // обновляем view
            var path = '/search/' + ttype + '/';

            var params = window.location.search;

            var url = path + params;

            var line = _this.lines[ttype],
                $line = $(line),
                content = BEMHTML.apply([
                    {
                        block: 'b-transport',
                        elem: 'item',
                        elemMods: {column: 'left'},
                        content: [
                            {
                                block: 'b-link',
                                url: url,
                                mix: [
                                    {block: 'b-transport', elem: 'title'}
                                ],
                                content: [
                                    {
                                        block: 'b-icon-carrier',
                                        elemMods: {
                                            type: ttype
                                        }
                                    },
                                    data['count-text']
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'item',
                        block: 'b-transport',
                        elemMods: {column: 'middle'},
                        content: {
                            elem: 'time-in-path',
                            content: data['min-duration-text']
                        }
                    },
                    {
                        elem: 'item',
                        block: 'b-transport',
                        elemMods: {column: 'right'},
                        content: {
                            block: 'b-transport',
                            elem: 'price',
                            content: data['min-tariff-text']
                        }
                    }
                ]);

            if (!$line.length) {
                $line = $(BEMHTML.apply({
                    block: 'b-transport',
                    elem: 'line',
                    content: []
                }));

                _this.lines[ttype] = $line.bem('b-transport__line');

                DOM.append($(_this.domElem).find('.b-transport__body'), $line);

                $(_this.domElem).find('.b-transport__line').addClass('i-bem');

                DOM.init($(_this).find('.b-transport__body'));

            }

            $line.html(content);
        });

        info.ts = response.ts;

        return response.done;

    }

});

})();
