(function () {

var DOM = BEM.DOM;

BEM.DOM.decl('b-transport', {
    onSetMod: {
        js: function () {
            this.domElem.delegate('.b-transport__line', 'click tap', this.handleLineClick.bind(this));
        }
    },

    handleLineClick: function (e) {
        var $line = $(e.currentTarget);
        var url = $line.find('a').attr('href');

        if (!!url) {
            window.location = $line.find('a').attr('href');
        }
    },

    ajaxUpdate: function (info, response) {
        var _this = this,
            form = $('.b-form').bem('b-form'),
            url = form.buildUrl(),
            data = response.data;

        $.each(data, function (ttype, data) {
            var line = _this.lines[ttype],
                $line = $(line),
                content = BEMHTML.apply([
                    {
                        block: 'b-transport',
                        elem: 'item',
                        elemMods: {column: 'left'},
                        content: [
                            {
                                block: 'b-link',
                                url: url + '&search_type=' + ttype,
                                mix: [
                                    {block: 'b-transport', elem: 'title'}
                                ],
                                content: [
                                    {
                                        block: 'b-icon-carrier',
                                        elemMods: {
                                            type: ttype
                                        }
                                    },
                                    data['count-text']
                                ]
                            },
                            {
                                block: 'b-transport',
                                elem: 'time-in-path',
                                content: data['min-duration']
                            }
                        ]
                    },
                    {
                        elem: 'item',
                        block: 'b-transport',
                        elemMods: {column: 'right'},
                        content: {
                            block: 'b-transport',
                            elem: 'price',
                            content: data['min-tariff']
                        }
                    }
                ]);

            if (!$line.length) {

                $line = $(BEMHTML.apply({
                    block: 'b-transport',
                    elem: 'line',
                    content: []
                }));

                _this.counts[ttype] = 0;
                _this.durations[ttype] = 0;
                _this.tariffs[ttype] = 0;

                _this.lines[ttype] = $line.bem('b-transport__line');

                DOM.append($(_this.domElem).find('.b-transport__body'), $line);

                $(_this.domElem).find('.b-transport__line').addClass('i-bem');

                DOM.init($(_this).find('.b-transport__body'));
            }

            $line.html(content);
        });

        info.ts = response.ts;

        return response.done;
    }

});

})();
