(function () {

var GLOBAL = BEM.blocks['i-global'];
var _request = null;

BEM.decl('dataprovider', {
    get: function (val, callback, additionParams) {
        this.abort();
        additionParams = additionParams || {};
        var type = this.params.suggestsType,
            url = '//' + GLOBAL.param('suggests-domain') + '/' + type + '?callback=?',
            limit = additionParams.limit || GLOBAL.param('suggests-limit');

        _request = $.ajax({
            url: url,
            data: this.makeQueryParam(val, limit, additionParams),
            dataType: 'jsonp',
            crossDomain: true,
            traditional: true,
            timeout: 5000
        });

        return _request.then(function (data) {
            var suggests = data[1],
                items = suggests.slice(0, limit);

            if (callback) {
                callback.call(this.params.callbackCtx, items);
            }

            return items;
        }.bind(this));
    },
    makeQueryParam: function (val, limit, additionParams) {
        var lang = GLOBAL.param('lang'),
            format = 'old';

        if (lang === 'tr') {
            format = 'rasp_tr';
        }

        return $.extend({
            limit: limit,
            query: (val || '').toLowerCase(),
            t_type_code: this.params.ttype,
            client_city: GLOBAL.param('client-city-geo-id'),
            lang: GLOBAL.param('lang'),
            format: format,
            national_version: GLOBAL.param('national-version')
        }, additionParams.urlParams || {});
    },
    abort: function () {
        if (_request) {
            _request.abort();
            _request = null;
        }
    }
});

})();
