(function () {
var GLOBAL = BEM.blocks['i-global'];
var _validateRequest = null;

BEM.decl({name: 'form-dataprovider', baseBlock: 'dataprovider'}, {
    get: function (val, callback) {
        if (!this._form) {
            this._form = $('.b-form').bem('b-form');
        }

        var limit = GLOBAL.param('suggests-limit'),
            itemsPromise = this.__base(val,/*callback*/ null, {
                urlParams: this._getSearchUrlParams(),
                // если нужно, показывать ссылку 'показать еще' спрашиваем на 1 элемент больше
                limit: GLOBAL.param('national-version') === 'tr' ? limit : limit + 1
            });

        $.when(itemsPromise, this._validateForm())
            .then(function (items, isValid) {
                this._updateLinks(this._buildFootLink(), limit, items, isValid);
                callback.call(this.params.callbackCtx, items.slice(0, limit));
            }.bind(this));
    },
    abort: function () {
        this.__base();
        if (_validateRequest) {
            _validateRequest.abort();
            _validateRequest = null;
        }
    },
    _getSearchUrlParams: function () {
        var urlParams = {},
            type = this.params.suggestsType;

        if (type === 'common' || type === 'suburban') {
            if (this.params.field === 'from') {
                urlParams.other_point = this._form.to.keyVal();
            } else {
                urlParams.other_point = this._form.from.keyVal();
            }
        }

        return urlParams;
    },
    _validateForm: function () {
        var validateUrl = '/form-validate/';

        var validateParams = {
            ttype: this.params.ttype,
            fromName: this._form.from.val(),
            fromId: this._form.from.keyVal(),
            toName: this._form.to.val(),
            toId: this._form.to.keyVal()
        };

        _validateRequest =  $.ajax({
            url: validateUrl,
            data: validateParams,
            timeout: 5000
        });

        return _validateRequest.then(function (data) {
            return data.form.is_valid;
        });
    },
    _updateLinks: function (footLink, limit, items, isValid) {
        if (items.length > limit && isValid) {
            this._form.from.link = footLink;
            this._form.to.link = footLink;
        }
    },
    _buildFootLink: function () {
        return this._form.buildUrl() + '&validationOff=' + this.params.field;
    }
});
})();
