(function () {

    BEM.decl('i-querystring', {}, {
        /**
         * Разбирает строку запроса.
         *
         * @param {String} str
         * @returns {Object}
         */
        parse: function (str) {
            if (!str) {
                return {};
            }

            // Если в объекте объявлено свойство hasOwnProperty, то вызов
            // obj.hasOwnProperty(prop) может завершиться ошибкой или работать некорректно.
            var hasOwnProperty = Object.prototype.hasOwnProperty;

            return str.split('&').reduce(function (result, pair) {
                if (pair) {
                    var eq = pair.indexOf('=');
                    var name;
                    var value;

                    if (eq >= 0) {
                        name = pair.substr(0, eq);
                        value = pair.substr(eq + 1);
                    } else {
                        name = pair;
                        value = '';
                    }

                    name = decodeURIComponent(name);
                    // RASPTICKETS-2373 Uncaught URIError: URI malformed
                    value = value.replace(/%([^\dA-F])/g, '%25$1');
                    // decodeURIComponent не заменяет + на пробел
                    try {
                        value = decodeURIComponent(value).replace(/\+/g, ' ');
                    } catch (e) {
                        value = '';
                    }

                    if (!hasOwnProperty.call(result, name)) {
                        result[name] = value;
                    } else if (Array.isArray(result[name])) {
                        result[name].push(value);
                    } else {
                        result[name] = [result[name], value];
                    }
                }
                return result;
            }, {});
        },

        /**
         * Преобразует объект в строку запроса.
         *
         * @param {Object} obj
         * @returns {String}
         */
        stringify: function (obj) {
            return Object.keys(obj)
                .reduce(function (result, name) {
                    var value = obj[name];
                    if (Array.isArray(value)) {
                        value.forEach(function (value) {
                            addParam(result, name, value);
                        });
                    } else {
                        addParam(result, name, value);
                    }
                    return result;
                }, [])
                .join('&');
        }
    });

    function addParam(result, name, value) {
        /* jshint eqnull: true */
        if (value == null) {
            value = '';
        } else {
            // По спецификации пробел в параметрах должен заменяться на +, но
            // encodeURIComponent заменяет его на %20
            value = encodeURIComponent(value).replace(/%20/g, '+');
        }
        result.push(encodeURIComponent(name) + '=' + value);
    }

}());

