(function (w) {

var onLoad = $.Deferred(); // используем дефереды, так как событие load поджигается один раз
$(w).on('load', function () {
    isReady = true;
    onLoad.resolve();
});

var isReady = false;

BEM.decl('i-stat-counter', {}, {
    reachGoal: function () {
        var args = arguments;

        if (!isReady) {
            onLoad.then(function () {
                // тут можно падать, так как это вызывается через setTimeout
                reachGoal.apply(null, args);
            });
            return;
        }

        reachGoal.apply(null, args);
    },
    awaps: function (url, klass) {
        try {
            if (!url) {
                return;
            }

            var img = document.createElement('img');
            img.src = url + (url.indexOf('?') >= 0 ? '&' : '?') + '_=' + Math.floor((Math.random() * 100000) + 1);

            img.className = klass;
            document.body.appendChild(img);
        } catch (e) { }
    }
});

function reachGoal(name, params) {
    // TOUCHRASP-1622
    if (typeof params === 'object') {
        params = Object.keys(params).reduce(function (newParams, key) {
            newParams[name + '-' + key] = params[key];

            return newParams;
        }, {});
    }
    try {
        var yaCounter = window.yaCounter;
        yaCounter.reachGoal(name, params);
    } catch (e) { }
}

}(window));

