BEM.DOM.decl({name: 'input', modName: 'filter', modVal: 'yes'}, {

    onSetMod: {
        js: function () {

            this.__base.apply(this, arguments);

            var _this = this;

            _this.bindTo('control', 'keyup', _this.onKeyPress);

            this.previous_value = '';

            var NORM_CHAR_MAP = {
                'ё': 'е',
                'ö': 'o',
                'ü': 'u',
                'ı': 'i',
                'ї': 'i',
                'İ': 'I',
                'ş': 's',
                'ç': 'c',
                'ğ': 'g'
            };

            function normalize(str) {
                return str.split('').map(function (i) {
                    return NORM_CHAR_MAP[i] || i;
                }).join('');
            }

            this.on('change', function () {
                if (this.event_id) {
                    clearTimeout(this.event_id);
                }

                this.event_id = setTimeout(function () {
                    var newValue = normalize(this.val());

                    if (newValue !== this.previous_value) {
                        this.trigger('filter-change', newValue);
                        this.previous_value = newValue;
                    }

                    this.event_id = null;
                }.bind(this), 1000);

            }.bind(this));
        }
    },

    onKeyPress: function () {
        var value = this.elem('control').val();

        this.val(value);
    }

});
