
(function () {
var touchStarted = false, // detect if a touch event is sarted
    currX = 0,
    currY = 0,
    cachedX = 0,
    cachedY = 0;

var getPointerEvent = function (event) {
    return event.originalEvent && event.originalEvent.targetTouches ? event.originalEvent.targetTouches[0] : event;
};

var DOM = BEM.DOM,
    KEYDOWN_EVENT = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown';

DOM.decl({name: 'input', modName: 'pick', modVal: 'yes'}, {

    onSetMod: {
        js: function () {
            this._applyFromInputSuggestYes();
            this.__base.apply(this, arguments);

            var _this = this,
                keyInput = this.findElem('key');

            this.link = null;

            this._keyInput = keyInput.length ? keyInput : this.appendKeyInput();

            this.params.dataprovider.input = this;

            this.on('clear', function () {

                _this.keyVal('');

            });

            this.bindTo('control', 'keyup', function (e) {

                if (e.keyCode === 8 || _this.val().length === 1) {

                    _this._preventRequest = false;

                    _this.keyVal('');

                }

            });

            this.on('update-items', function () {

                if (_this._preselected) {

                    $.each(this._metaItems, function (i) {

                        if (this[0] && this[0] === _this._preselected.key || this[1] === _this._preselected.text) {

                            _this._onEnterItem(_this._items[i]);

                        }

                    });
                }

                this.del('_preselected');

            });

            this.on('data-received', function (e, data) {

                this._enteredVal = this.val();

                var dataItems = data.items || data;

                if (dataItems.length) {
                    if ($('.b-content_calendar_yes').is(':visible')) {
                        return;
                    }
                }

            });
        }
    },

    // COPYPASTE из islands-components/common.blocks/input/_suggest/input_suggest_yes.js
    // почему-то этот код вообще не выполняется, хотя и висит в onSetMod: 'js'
    _applyFromInputSuggestYes: function () {
        var _this = this;

        if (_this.params.foot) {
            _this.foot = _this.params.foot;
        }

        _this._preventRequest = true;

        _this.__base.apply(_this, arguments);

        // последнее значение, введенное пользователем с клавиатуры
        _this._userVal = _this.val();

        // выключаем браузерный саджест
        var focused = _this._focused;
        if (focused) {
            _this.delMod('focused');
        }
        _this.elem('control').attr('autocomplete', 'off');
        _this._preventRequest = false;
        if (focused) {
            _this.setMod('focused', 'yes');
        }

        _this._items = [];
        _this._curItemIndex = -1;

        this.bindToWin('resize', $.throttle(this._setWidth, 60));
    },

    _onClearClick: function () {

        this.keyVal('');

        this._preventRequest = false;

        this.__base.call(this, arguments);

    },

    _needUpdate: function (selectResult) {
        return (typeof selectResult === 'object') ? selectResult.needUpdate : selectResult !== false;
    },

    _onSelectItem: function (e, byKeyboard) {
        this.getDataprovider().abort();
        var item = e.block,
            selectResult = item.select(byKeyboard || false),
            needUpdate = this._needUpdate(selectResult),
            needEvent = (typeof selectResult === 'object') && selectResult.needEvent;

        this._preventRequest = true;

        this._curItemIndex = this._getItemIndex(item);

        if (needUpdate) {
            this._userVal = item.val();
            this.val(this._userVal, {
                source: 'autocomplete',
                itemIndex: this._curItemIndex
            })._getPopup().hide();
        }

        if (byKeyboard) {
            this.del('_preventRequest');
        } else {
            if (!needUpdate) {
                this._preventHide = true;
            }
        }

        if (needUpdate || needEvent) {
            this.trigger('select', {
                item: item, byKeyboard: byKeyboard
            });
        }

        this.tryRefocusOnNextInput();

    },

    tryRefocusOnNextInput: function () {
        var name = this.name();
        if (name !== 'fromName') {
            return;
        }

        var form = $('.b-form').bem('b-form'),
                inputs = form.getInputs();

        this.afterCurrentEvent(function () {

            this.delMod('focused');

            var val = inputs.toName.val();

            if (!val) {

                inputs.toName.setMod('focused', 'yes');

            }

        });
    },

    keyVal: function (val) {

        if (typeof val === 'undefined') {

            return this._keyInput.val();

        }

        this._keyInput.val(val);

        this.trigger('keyChange');

        return this;

    },

    _buildItemsHtml: function (data) {
        var _this = this;

        if ($('.b-content_calendar_yes').is(':visible')) {

            return;

        }

        this._metaItems = data;

        data = $.map(data, function (item) {

            return item[2];

        });

        if (this.link) {

            data.push(['foot', '<a class="b-link" href="' + this.link + '">' + I18N('input', 'all-variants') + '</a>']);

        }

        return BEMHTML.apply($.map(data, function (d) {
            var data = d.text || d;

            var autocompleteItem = {
                    block: 'b-autocomplete-item',
                    data: data,
                    mods: {
                        type: $.isArray(data) ? data[0] : 'text'
                    },
                    suggestVersion: _this.params.dataprovider.version || 4
                },
                prefs;

            if (d.hl) {
                autocompleteItem.hl = d.hl;
            }

            if ($.isArray(data)){
                prefs = data.concat().pop();
                if ($.isPlainObject(prefs)) {
                    $.extend(autocompleteItem, prefs);
                }
            }

            return autocompleteItem;

        }));

    },

    appendKeyInput: function () {
        $('<input type="hidden" name="' + this.params['key-name'] + '" />').appendTo(this.domElem);
    },

    /**
    * Ленивое получение попапа
    * @returns {BEM} блок попапа
    */
    _getPopup: function () {

        var _this = this;
        if (!_this._popup) {
            var block = _this.__self.getName(),
                content = [{
                    elem: 'items',
                    tag: 'ul',
                    mix: [{
                        block: block,
                        elem: 'popup-items'
                    }]
                }],
                popupMix = Array.isArray(_this.params.popupMixs) ? _this.params.popupMixs : [];

            if (_this._hasPopupFade()) {
                content.push({
                    block: block,
                    elem: 'fade'
                });
            }

            popupMix.push({
                block: block,
                elem: 'popup',
                mods: _this.params.popupMods,
                js: {
                    uniqId: _this._uniqId
                }
            });

            _this._popup = $(BEMHTML.apply({
                block: 'popup',
                mods: {
                    animate: 'no'
                },
                mix: popupMix,
                js: {
                    directions: 'bottom-left'
                },
                content: {
                    elem: 'content',
                    content: content
                }
            })).bem('popup')
                .on({
                    show: function () {
                        _this
                            .bindTo('keypress', _this._onKeyPress)
                            .bindTo(KEYDOWN_EVENT, _this._onKeyDown);
                    },
                    hide: function () {
                        _this
                            .unbindFrom('keypress ' + KEYDOWN_EVENT)
                            ._curItemIndex = -1;
                    }
                });

            // при первом создании попапа подписываемся на live-события его элементов
            $.each({
                    touchstart: _this._onTouchStart,
                    mousedown: _this._onTouchStart,
                    MSPointerDown: _this._onTouchStart,

                    touchend: _this._onTouchEnd,
                    touchcancel: _this._onTouchEnd,
                    mouseup: _this._onTouchEnd,
                    MSPointerUp: _this._onTouchEnd,

                    touchmove: _this._onTouchMove,
                    mousemove: _this._onTouchMove,
                    MSPointerMove: _this._onTouchMove

                    // tap         : _this._onSelectItem
                }, function (e, fn) {
                    BEM.blocks['b-autocomplete-item'].on($(_this._popup.domElem), e, function (e) {
                        fn.call(_this, e);
                    });
                });

            DOM.init(_this._popup.domElem);
        }

        return _this._popup;

    },
    _onTouchStart: function (e) {
        var pointer = getPointerEvent(e);
        // caching the current x
        cachedX = currX = pointer.pageX;
        // caching the current y
        cachedY = currY = pointer.pageY;
        // a touch event is detected
        touchStarted = true;

        this._preventHide = true;
    },

    _onTouchEnd: function (e) {
        e.preventDefault();

        touchStarted = false;
        this._preventHide = false;

        if ((Math.abs(cachedX - currX) < 5) && (Math.abs(cachedY - currY) < 5)) {
            this._onSelectItem(e);
        }
    },

    _onTouchMove: function (e) {
        var pointer = getPointerEvent(e);
        currX = pointer.pageX;
        currY = pointer.pageY;
    },

    val: function (val, data) {

        if (data && data.source === 'autocomplete') {

            var item = this._metaItems[data.itemIndex],
                key = item[0];

            val = item[1];

            this.keyVal(key);

            // Уточнение не окончательно, продолжаем
            if (!key && val !== this.val()) {
                this._doRequest();
            }

        }

        if (data && data.preventRequest && !this._preventRequest) {

            this._preventRequest = true;

            this.afterCurrentEvent(function () {

                this.del('_preventRequest');

            });

        }

        return this.__base.call(this, val, data);

    },

    getState: function () {

        return this._getState();

    },

    setState: function (state) {

        this._setState(state);

    },

    _getState: function () {

        return {
            val: this.val(),
            keyVal: this.keyVal(),
            _enteredVal: this._enteredVal,
            _preselected: this._preselected
        };

    },

    _setState: function (state) {

        this._enteredVal = state._enteredVal;
        this._preselected = state._preselected;

        this.val(state.val, {
            preventRequest: true
        });
        this.keyVal(state.keyVal);

    }

});

})();
