BEM.DOM.decl({
    block: 'popup',
    modName: 'autoclosable',
    modVal: 'yes'
}, {
    onSetMod: {
        'js': function () {
            this.__base.apply(this, arguments);

            this.on('hide', this._disableAutoclosable);
        }
    },
    _enableAutoclosable : function() {
        var under = this._under;

        if(this.hasMod(under, 'type', 'paranja')) {
            /*
             * NOTE: contentWindow, contentWindow.document для разных браузеров
             * Некоторые не обрабатывают клик на contentWindow
             * Отписываться от события leftclick здесь не нужно
             */
            under.is('iframe') &&
                (under = $([under[0].contentWindow, under[0].contentWindow.document]));

            this.bindTo(under, 'click tap', function(e) {
                e.stopPropagation();
                this.hide();
            });
        }

        this.bindToDoc('click tap', function(domEvent) {
            if(this._isRelatedNode($(domEvent.target))) {
                return;
            }

            var e = $.Event('outside-click');
            this.trigger(e, domEvent);
            e.isDefaultPrevented() || this.hide();
        });

    },
    _disableAutoclosable : function() {

        this.hasMod(this._under, 'type', 'paranja') &&
            this.unbindFrom(this._under, 'click tap');

        this.unbindFromDoc('click tap');

    },
});

