(function($) {

BEM.DOM.decl('popup',  /** @lends block.prototype */ {
    onSetMod: {
        'js': function () {
            this.__base.apply(this, arguments);

            // FIX: TOUCHRASP-923 — Снова прыгает фокус в форме поиска
            this.bindTo('MSPointerUp MSPointerDown MSPointerMove touchend touchcancel touchstart tap', function(e){
                e.stopPropagation();
            });

            this.on('show', function () {
                $(this.domElem).css('position', 'absolute');
            });
        }
    },
    // COPYPASTE from ver3.6 islands-components/common.blocks/popup/popup.js
    getOwnerPos: function() {

        var pos;

        if(this._owner) {
            pos = this._getPosOf(this._owner);

            // XXX: IE 10 Scale fix (https://st.yandex-team.ru/ISLCOMPONENTS-13)
            if('pageYOffset' in window) {

                pos.top -= (window.pageYOffset - (document.documentElement.scrollTop || document.body.scrollTop));
                pos.left -= (window.pageXOffset - (document.documentElement.scrollLeft || document.body.scrollLeft));
            }
        }

        return pos || this._userPosition;

    }
},
    /** @lends block */ {
    live : function() {

        this.liveBindTo('close', 'touchend mouseup', function() {
            this.hide();
        });

    }

});

})(jQuery);

