(function() {

var DOM = BEM.DOM,
    URL = BEM.blocks['i-url'];

DOM.decl('touch-head', {

    onSetMod: {

        js: function() {

            var _this = this;

            this.bindTo('radio', 'click', function(e) {

                if (_this.hasMod($(e.data.domElem), 'checked', 'yes')) {

                    return;

                }

                _this.onMouseDown(e);

            });

        }

    },

    onMouseDown: function(e) {

        var typeMod = this.getMod('type'),
            controlVal = this.findElem(e.data.domElem, 'control').val();

        if (controlVal == 'null') {

            controlVal = null;

        }

        switch (typeMod) {

            case 'filter':

                var $direction = $('.arrow-box'),
                    params = {
                        filter: controlVal
                    };

                if ($direction.length) {

                    var direction = $direction.bem('arrow-box').getSelected().text();

                    if (direction.toLowerCase() != I18N('b-switcher', 'all-directions')) {

                        if ($.inArray(direction.toLowerCase(), [I18N('b-switcher', 'arrival'), I18N('b-switcher', 'departure')]) > -1) {

                            params['direction'] = direction.toLowerCase();

                        } else {

                            params['direction'] = direction;

                        }

                    }

                }

                window.location.href = URL.changeParams(window.location.href, params);

                break;

            case 'span':

                window.location.href = URL.changeParams(window.location.href, {span: controlVal});

                break;

        }

    }

});

})();
