# -*- coding: utf-8 -*-

from itertools import izip
from travel.rasp.touch.touch.core.helpers.thread import get_best_indexes_of_stations


def get_thread_graphic(rt_stations, from_station, to_station):
    """Разбиваем станции по схемам"""

    user_start, user_end = get_best_indexes_of_stations(from_station, to_station, rt_stations)

    scheme_borders = _get_transfer_segments(rt_stations, user_start, user_end)

    schemes = _group_station_by_segments(scheme_borders, rt_stations, user_start, user_end)

    return _insert_transfers_scheme(schemes)


def _get_transfer_segments(rt_stations, user_start, user_end):
    """Разбивает нитку на границы по пересадкам"""

    transfers = [user_start] + [i for i in range(user_start + 1, user_end) if rt_stations[i].is_combined] + [
        user_end]

    return [(start, end) for start, end in izip(transfers, transfers[1:])]


def _group_station_by_segments(segments, stations, user_start, user_end):
    """группируем станции по границам пересадок/посадок"""

    result = []

    for i, segment in enumerate(segments):
        start, end = segment

        segments_nodes = [create_station_node(station=stations[start], include_in_thread=True, event='departure'),
                          create_collapsed_node(stations=stations[start + 1:end], include_in_thread=True),
                          create_station_node(station=stations[end], include_in_thread=True, event='arrival')
                          ]

        # пользователь сел на промежуточную станцию
        if i == 0 and user_start != 0:
            segments_nodes = [create_station_node(station=stations[0],
                                                  include_in_thread=False,
                                                  event='departure'),
                              create_collapsed_node(stations=stations[1:user_start],
                                                    include_in_thread=False)] + segments_nodes

        # пользователь сел на промежуточную станцию
        if i == len(segments) - 1 and user_end != len(stations) - 1:
            segments_nodes = segments_nodes + [create_collapsed_node(stations=stations[user_end + 1:len(stations) - 1],
                                                                     include_in_thread=False),
                                               create_station_node(station=stations[-1],
                                                                   include_in_thread=False,
                                                                   event='arrival')]

        result.append(segments_nodes)

    return [create_scheme(nodes) for nodes in result]


def _insert_transfers_scheme(schemes):
    """Между каждой схемой вставляем пересадку"""
    result = []

    for scheme in schemes[:-1]:
        result.append(scheme)
        result.append(create_transfer(scheme['nodes'][-1]))

    result.append(schemes[-1])

    return result


# Модельки
def create_scheme(nodes):
    return {
        'type': 'scheme',
        'nodes': nodes
    }


def create_transfer(node):
    return {
        'type': 'transfer',
        'node': node
    }


def create_station_node(station, include_in_thread, event):
    return {
        'type': 'station',
        'station': station,
        'include_in_thread': include_in_thread,
        'event': event
    }


def create_collapsed_node(stations, include_in_thread):
    return {
        'type': 'collapsed-station',
        'stations': stations,
        'include_in_thread': include_in_thread
    }
