# -*- coding: utf-8 -*-

from django.http import HttpResponseRedirect, HttpResponsePermanentRedirect
from django.conf import settings

from url_mapper import TouchMapper

TICKET_CLID = 2289669

def redirect_to_main_rasp(request):
    touch_url = settings.TOUCH_URL + request.get_full_path()
    rasp_domain = settings.NATIONAL_RASP_DOMAINS[request.tld]

    mapper = TouchMapper(rasp_domain, 'https')

    url = mapper.get_rasp_url(touch_url)

    return HttpResponsePermanentRedirect(url)
