# -*- coding: utf-8 -*-

import os
import logging
import socket

import blackbox
from library.python.django.utils import patch_settings_for_arcadia  # noqa

from common.settings import *
from travel.rasp.library.python.common23.logging.qloud import context_extractor
from travel.rasp.touch.tariffs.settings import *
from url_mapper.settings import *

PKG_VERSION = '@@PKG_VERSION@@'

DEBUG = False

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

ERRORS_RECIPIENTS = ['rasp-errors@yandex-team.ru']

DEFAULT_FROM_EMAIL = SERVER_EMAIL = 'yandex-rasp-touch@' + unicode(socket.gethostname())

# Hosts/domain names that are valid for this site.
# "*" matches anything, ".example.com" matches example.com and all subdomains
ALLOWED_HOSTS = ['*']

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

# In production/testing environment project binary located in /app, in development environment these could be anywhere
# so we assume that's right path should be specified in local_settings.py.
# In order to make some weir experiments possible - we're firstly looking for environmental variable.
PROJECT_PATH = os.getenv('RASP_TOUCH_PROJECT_PATH', '/app')

BANNER_HTTP_TIMEOUT = 0.2

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = ''

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = ''

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
# 'django.contrib.staticfiles.finders.DefaultStorageFinder',
]

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'vuedpm441k5zp)nm3^ykc281v!0+pk3^$r9+*uy$47rge8%*vp'


TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'debug' : False,
        },
    },
]


MIDDLEWARE_CLASSES = (
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'common.middleware.ping.PingResponder',
    'common.middleware.request_activator.RequestActivator',
    'common.middleware.syncdb.SyncDB',
    'common.middleware.now.Now',
    'common.middleware.host.Host',
    'common.middleware.uatraits_detector.UatraitsDetectorMiddleware',
    'common.geotargeting.middleware.GeoTargeting',
    'common.middleware.blackbox_session.BlackboxSessionMiddleware',
    'common.middleware.yandexuid.YandexuidMiddleware',
    'common.middleware.yauser.YaUserMiddleware',
    'common.middleware.locale_request.Locale',
    'common.middleware.language.LanguageMiddleware',
    'django.middleware.common.CommonMiddleware',
)

ROOT_URLCONF = 'travel.rasp.touch.touch.urls'

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [
    'geosearch',
    'route_search',
    'stationschedule',
    'raven.contrib.django.raven_compat',
]

XGETTEXT_KEYSETS['touch-rasp'] = {
    'filename': 'keysets/keyset.json',
    'dirs': [
        'templates',
        'forms',
        'views',
        'stationschedule'
    ]
}

# (path, prefix, blocks)
XGETTEXT_BEM_BLOCKS = (
    (
        ('markup', 'desktop.blocks'),
        'desktop.blocks',
        (
            'b-filters',
            'b-form',
            'b-routers',
            'b-switcher',
            'input',
            'likes',
            'b-action-button',
            'b-buy',
            'b-blablacar'
        )
    ),
    (
        ('static', 'touch.blocks'),
        'touch.blocks',
        (
            'b-change-langs',
            'b-company-card',
            'b-mobile-lang-switcher',
            'b-page',
            'b-user-settings',
            'footer',
            'header2',
            'services-table'
        )
    ),
)

XGETTEXT_FILES = ()

TANKER_KEYSETS = {}

KEYSETS_PATH = os.path.join(os.path.dirname(__file__), 'keysets')

FORCE_SCRIPT_NAME = ""

DISABLE_YAUTH = False

BETA_FIELD = ('subscription.suid.668', 'beta_tester')

PASSPORT_FIELDS = [blackbox.FIELD_LOGIN, BETA_FIELD]

ENVIRONMENT = 'production'

MARKUP_URL = '//yandex.st/rasp-touch/%s/' % PKG_VERSION

TOUCH_NATIONAL_DOMAINS = ('ru', 'ua', 'by', 'kz', 'uz', 'com.tr')

RASP_DOMAIN = 'rasp.yandex.ru'
RASP_URL = 'http://%s/' % RASP_DOMAIN

NATIONAL_AVIA_DOMAINS = {
    'ru': 'travel-test.yandex.ru/avia',
    'ua': 'front.avia.tst.yandex.ua',
    'kz': 'front.avia.tst.yandex.kz'
}

NATIONAL_RASP_DOMAINS = {
    'ru': 'rasp.yandex.ru',
    'ua': 'rasp.yandex.ua',
    'by': 'rasp.yandex.by',
    'kz': 'rasp.yandex.kz',
    'uz': 'rasp.yandex.uz',
    'com.tr': 'seyahat.yandex.com.tr'
}

NATIONAL_DOMAIN_MAP = {
    'ru': 't.rasp.yandex.ru',
    'ua': 't.rasp.yandex.ua',
    'by': 't.rasp.yandex.by',
    'kz': 't.rasp.yandex.kz',
    'uz': 't.rasp.yandex.uz',
    'tr': 'm.seyahat.yandex.com.tr'
}

TIME_CORRECTION_URL = RASP_URL + 'time/correction/'

DOMAIN_NAME = 't.rasp.yandex.ru'
TOUCH_URL = 'https://' + DOMAIN_NAME

# RASPFRONT-7713
REMOTE_ADDR_META_VARIABLE = 'HTTP_X_RASP_REAL_IP'
REMOTE_ADDR_META_VARIABLE_FALLBACK = 'HTTP_X_REAL_IP'

RASP_TIMEOUT = 1

TIME_CORRECTION_URL = 'http://rasp.yandex.ru/time/correction/'

TINYURL = 'http://tinyurl-test.yandex.ru/tiny'

DISABLE_ANTIROBOT = False

TTYPE_COLOR_MAP = {
    'train': 'red',
    'plane': 'blue',
    'sea': 'dark-blue',
    'river': 'dark-blue',
    'water': 'dark-blue',
    'bus': 'orange',
    'suburban': 'green',
    'helicopter': 'blue',
    'aeroex': 'red'
}

EXPRESS_COLOR = '#db5640'

DEFAULT_TOUCH_TABLO_LIMIT = 20
STATION_SCHEDULE_AMOUNT_NEAREST = 5
STATION_SCHEDULE_AMOUNT = 100

ALL_SUGGESTS_LIMIT = 10000000
SUGGESTS_LIMIT = 5

CHECK_IS_USER_VALID = False
IGNORE_DAEMON_CACHE = False
ORDER_BILLING_ENABLED = True
MIN_STAY_TIME = datetime.timedelta(hours=1)

WSGI_APPLICATION = 'travel.rasp.touch.touch.wsgi.application'

SUGGESTS_DOMAIN = ''

LOG_LEVEL = logging.INFO
TABLO_LOG_LEVEL = logging.INFO

SUPPORTED_DOMAINS = ['ru', 'ua', 'by', 'kz', 'uz']

SUPPORTED_HOSTS = []

DEBUG_METRIKA = False

SEARCH_LOG = 'log/search.log'
REDIR_LOG = 'log/order/redir.log'
PLANE_REDIR_LOG = 'log/order/plane_redir.log'
BUS_REDIR_LOG = 'log/order/bus_redir.log'
AUCTION_REDIR_LOG = 'log/order/auction_redir.log'
RASP_USERS_SEARCH_LOG = 'log/yt/search.log'

# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error when DEBUG=False.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.


try:
    SUBMODULE_STATUS = open(os.path.join(os.path.dirname(__file__), 'submodule-status')).read()
except IOError:
    SUBMODULE_STATUS = None


PRECACHE_MANAGERS = (
    'common.models.schedule:Company.objects',
    'common.models.geo:Settlement.objects',
    'common.models.geo:Country.objects',
    'common.models.geo:ExternalDirection.objects',
    'common.models.geo:SuburbanZone.objects',
    'common.models.geo:StationType.objects',
    'common.models.geo:Region.objects',
    'common.models.geo:StationTerminal.objects',
    'common.models.schedule:Supplier.objects',
    'common.models.transport:TransportType.objects',
    'common.models.schedule:RThreadType.objects',
    'common.models.transport:TransportModel.objects',
    'common.models.geo:StationMajority.objects',
    'common.models.tariffs:TariffType.objects',

    'common.models.geo:Direction.objects',
    'common.models_abstract.geo:Station2Direction',
    'geosearch.models:DefaultPoint.objects',
)

SUBURBAN_AMOUNT_IN_SEARCH = 5

METRIKA_IDS = {
    'com.tr': 22352497,
    'ru': 22352497,
    'ua': 22352497,
    'by': 22352497,
    'kz': 22352497,
    'uz': 22352497,
}

# RASPFRONT-1958 используется для запросов к ticketdaemon
PROJECT_CODE = 'rasp_touch'

PYLOGCTX_REQUEST_EXTRACTOR = context_extractor

patch_settings_for_arcadia()
