module.exports = function (config) {
    var browserSupport = [
        'iOS >= 5',
        'Android >= 2',
        'Chrome >= 35',
        'OperaMobile 12',
        'Opera 12',
        'Firefox >= 15',
        'IE >= 8'
    ];

    config.setLanguages(['ru', 'uk', 'tr']);

    config.nodes('/touch.bundles/**');

    config.mode('development', function () {
        config.nodeMask(/touch\.bundles\/.*/, function (nodeConfig) {
            nodeConfig.addTechs([
                use('priv', {mode: 'development'}),
                use('copy', {sourceTarget: '?.{lang}.js', destTarget: '_?.{lang}.js'}),
                use('copy', {sourceTarget: '?.ap.css', destTarget: '_?.css'}),
                use('copy', {sourceTarget: '?.{lang}.pub.js', destTarget: '_?.{lang}.pub.js'})
            ]);
        });
    });

    config.mode('production', function () {
        config.nodeMask(/touch\.bundles\/.*/, function (nodeConfig) {
            nodeConfig.addTechs([
                use('priv', {mode: 'production'}),
                use('borschik', {
                    sourceTarget: '?.{lang}.pub.js',
                    destTarget: '_?.{lang}.pub.js',
                    minify: true,
                    freeze: true
                }),
                use('borschik', {
                    sourceTarget: '?.ap.css',
                    destTarget: '_?.css',
                    minify: true,
                    freeze: true,
                    tech: 'cleancss'
                })
            ]);
        });
    });

    config.nodeMask(/touch\.bundles\/.*/, function (nodeConfig) {

        nodeConfig.addTechs([
            use('levels', {levels: getDesktopLevels()}),
            use('provider', {target: '?.bemdecl.js'}),
            use('deps'),
            use('files'),
            use('i18n-priv', {target: '?.priv.{lang}.js', lang: '{lang}'}),
            use('i18n-keysets', {lang: 'all'}),
            use('i18n-keysets', {lang: '{lang}'}),
            use('i18n-lang', {lang: 'all'}),
            use('i18n-lang', {lang: '{lang}'}),
            use('pub-js-i18n', {
                lang: '{lang}'
            }),
            use('priv-js-i18n-all', {
                langTargets: ['all'].concat(config.getLanguages()).map(function (lang) {
                    return '?.lang.' + lang + '.js';
                })
            }),
            use('js'),
            use('i18n-js', {lang: '{lang}'}),
            use('bh-bundle', {
                mode: 'production',
                bhOptions: {
                    jsAttrName: 'data-bem',
                    jsAttrScheme: 'json'
                },
                requires: {
                    i18n: {
                        globals: 'BEM.I18N'
                    }
                }
            }),
            use('css'),
            use('css-autoprefixer', {
                sourceTarget: '?.css',  // Source CSS
                destTarget: '?.ap.css', // Target
                browserSupport: browserSupport
            })
        ]);
        nodeConfig.addTargets([
            '_?.css',
            '?.bh.js',
            '?.all.priv.js',
            '?.{lang}.pub.js',
            '_?.{lang}.pub.js'
        ]);
    });

    function getDesktopLevels() {
        return [
            {path: 'vendors/islands/common.blocks', check: false},
            {path: 'vendors/islands/touch.blocks', check: false},
            {path: 'vendors/islands/touch-phone.blocks', check: false},
            {path: 'touch.blocks', check: true}
        ].map(function (l) {
                return config.resolvePath(l);
            });
    }

    // Хэш технологий
    var techs = {
        levels: require('enb/techs/levels'),
        files: require('enb/techs/files'),
        provider: require('enb/techs/file-provider'),
        copy: require('enb/techs/file-copy'),
        deps: require('enb/techs/deps-old'),
        'deps-merge': require('enb/techs/deps-merge'),
        js: require('enb/techs/js'),
        css: require('enb/techs/css'),
        'css-autoprefixer': require('enb-autoprefixer/techs/css-autoprefixer'),
        borschik: require('enb-borschik/techs/borschik'),
        priv: require('./techs/priv-js'),
        'i18n-keysets': require('enb/techs/i18n-merge-keysets'),
        'i18n-lang': require('enb/techs/i18n-lang-js'),
        'i18n-js': require('enb/techs/js-i18n'),
        'i18n-priv': require('enb-priv-js/techs/priv-js-i18n'),
        'priv-js-i18n-all': require('enb-priv-js/techs/priv-js-i18n-all'),
        'bh-bundle': require('enb-bh/techs/bh-bundle'),
        'pub-js-i18n': require('./techs/pub-js-i18n')

    };

    /**
     * Возвращает объект-технологию для `nodeConfig`
     *
     * @param {String} tech название технологии
     * @param {Object} [params] параметры для технологии
     * @returns {*[]}
     */
    function use(tech, params) {
        return [
            techs[tech],
            params || {}
        ];
    }
};
