/**
 * pub-js-i18n
 * ===========
 *
 * Собирает *{lang}.pub.js*-файл языковых файлов, *js* и *bh*.
 *
 * **Опции**
 *
 * * *String* **target** — Результирующий `pub.js`-файл. По умолчанию — `?.all.pub.js`.
 * * *String* **jsTarget** — Исходный `js`-файл. По умолчанию — `?.js`.
 * * *String* **lang** — Язык. Обязательная опция.
 * * *Array* **langTarget** — `lang.js`-файл конкретного языка. Например, `?.lang.ru.js`.
 *   По умолчанию — `?.lang.{lang}.js`.
 * * *Array* **allLangTarget** — `lang.all.js`-файл. По умолчанию — `?.lang.all.js`.
 * * *Array* **bhTarget** — `bh.js`-файл. По умолчанию — `?.bh.js`.
 */
module.exports = require('enb/lib/build-flow').create()
    .name('pub-js-i18n')
    .target('target', '?.{lang}.pub.js')
    .defineRequiredOption('lang')
    .useSourceFilename('jsTarget', '?.js')
    .useSourceFilename('allLangTarget', '?.lang.all.js')
    .useSourceFilename('langTarget', '?.lang.{lang}.js')
    .useSourceFilename('bhTarget', '?.bh.js')
    .justJoinFilesWithComments()
    .createTech();
