module.exports = function (bh) {
    // company= {
    //        'country': text,
    //        'png_icon_url': text,
    //        'svg_icon_url': text,
    //        'codes': array['string'],
    //        'contactInfo': text,
    //        'url': url,
    //        'email': text,
    //        'phone': text,
    //        'address': text
    // },
    bh.match('b-company-card', function (ctx, json) {
        var mapId = 'map-' + ctx.generateId();

        ctx.js({
            address: json.model.address,
            mapId: mapId
        });

        ctx.content([{
            elem: 'table',
            model: json.model
        }, {
            elem: 'map',
            mapId: mapId
        }]);
    });

    bh.match('b-company-card__map', function (ctx, json) {
        ctx.attr('id', json.mapId);
        ctx.attr('style', 'width: 100%; height: 250px');
    });

    bh.match('b-company-card__table', function (ctx, json) {
        ctx.tParam('model', json.model);

        ctx.content([
            {
                elem: 'head'
            },
            {
                elem: 'contacts'
            },
            {
                elem: 'tail'
            }
        ]);
    });

    bh.match('b-company-card__head', function (ctx) {
        ctx.content([
            {
                elem: 'title',
                content: ctx.tParam('model').name
            },
            {
                elem: 'info'
            }
        ]);
    });

    bh.match('b-company-card__info', function (ctx) {
        var model = ctx.tParam('model');
        var country = model.country;

        ctx.content([
            country && {
                elem: 'country',
                content: country
            },
            {
                elem: 'logo',
                content: {
                    block: 'b-company-logo',
                    model: model
                }
            }
        ]);
    });

    bh.match('b-company-card__contacts', function (ctx) {
        var model = ctx.tParam('model'),
            codes = model.codes,
            contactInfo = model.contactInfo,
            url = model.url,
            email = model.email,
            phone = model.phone,
            address = model.address;

        function link_item(title, text, url, type) {
            return {
                block: 'b-link',
                attrs: {target: '_blank'},
                mix: [{
                    block: 'b-company-card',
                    elem: 'item',
                    elemMods: {
                        type: type
                    }
                }],
                content: [
                    {
                        block: 'b-company-card',
                        elem: 'item-desc',
                        content: title
                    },
                    text
                ],
                url: url
            };
        }
        ctx.content([
            (codes.length || null) && {
                elem: 'item',
                elemMods: {
                    type: 'code'
                },
                title: bh.lib.i18n('b-company-card', 'code-title'),
                text: codes.join(' / ')
            },
            contactInfo && {
                elem: 'item',
                elemMods: {
                    type: 'contact-info'
                },
                title: bh.lib.i18n('b-company-card', 'contact-info-title'),
                text: contactInfo
            },
            url && link_item(bh.lib.i18n('b-company-card', 'site-title'), url, url, 'site'),
            email && link_item(bh.lib.i18n('b-company-card', 'e-mail-title'), email, 'mailto:' + email, 'email'),
            phone && link_item(bh.lib.i18n('b-company-card', 'phone-title'), phone, 'tel:' + phone, 'phone'),
            address && {
                elem: 'item',
                mix: [{
                    elem: 'map-picker'
                }],
                title: bh.lib.i18n('b-company-card', 'address-title'),
                text: address
            }
        ]);
    });

    bh.match('b-company-card__item', function (ctx, json) {
        ctx.content([
            {
                elem: 'item-desc',
                content: json.title
            },
            json.text
        ]);
    });
};
