(function () {
    var reachGoal = BEM.blocks['b-hit'].reachGoal;

    BEM.DOM.decl('b-company-card', {
        __onMap: function (ymaps) {
            var params = this.params;

            ymaps.ready(init);

            function init() {
                var zoom = 15,
                    zoomControl = new ymaps.control.ZoomControl({
                        options: {
                            size: 'small',
                            position: {
                                right: '10px',
                                top: '95px'
                            }
                        }
                    }),
                    myMap = new ymaps.Map(params.mapId, {
                        center: [55.76, 37.64],
                        zoom: zoom,
                        controls: [zoomControl]
                    });

                // прячем копирайты
                myMap.panes.get('copyrights').getElement().setAttribute('style', 'display: none');

                var geoCoder = ymaps.geocode(params.address);

                geoCoder.then(
                    function (res) {
                        var point = res.geoObjects.get(0).geometry.getCoordinates();
                        var myPlaceMark = new ymaps.Placemark(point);

                        myMap.setCenter(point, zoom);
                        myMap.geoObjects.add(myPlaceMark);
                    }
                );
            }
        }
    }, {
        live: function () {
            this.liveBindTo('map-picker', 'click', function () {
                this.toggleMod('map', 'shown');
                this.toggleMod('tail', 'shown');

                if (!this._mapInited) {
                    this._mapInited = true;
                    this.__onMap(window.ymaps);
                }

                reachGoal(this.getMod('map') === 'shown' ? 'COMPANY-SHOW-MAP' : 'COMPANY-HIDE-MAP');
            });

            this.liveBindTo('item', 'click', function (e) {
                var value = this.getMod(e.data.domElem, 'type');
                if (value) {
                    reachGoal('COMPANY-ITEM-CLICK', {
                        value: value
                    });
                }
            });
        }
    });
})();
