module.exports = function (bh) {

    // model= {
    //        'png_icon_url': text,
    //        'svg_icon_url': text,
    // },
    bh.match('b-company-logo', function (ctx, json) {
        var items = [];

        if (json.model.pngIconUrl) {
            items.push({
                elem: 'item',
                url: json.model.pngIconUrl,
                format: 'png'
            });
        }

        if (json.model.svgIconUrl) {
            items.push({
                elem: 'item',
                url: json.model.svgIconUrl,
                format: 'svg'
            });
        }

        if (items.length === 1) {
            items[0].forceShow = true;
        }

        return items;
    });

    bh.match('b-company-logo__item', function (ctx, json) {
        return {
            block: 'b-icon',
            mods: {
                format: json.format,
                'force-show': json.forceShow && 'yes'
            },
            url: json.url,
            width: '100px'
        };
    });
};
