(function (w) {
    // используем дефереды, так как событие load поджигается один раз
    var onLoad = $.Deferred();

    $(w).on('load', function () {
        onLoad.resolve();
    });

    BEM.DOM.decl('b-hit', {
        onSetMod: {
            js: function () {
                var jsParams = this.params;
                var event = jsParams.event || 'pointerclick';

                this.bindTo(event, function () {
                    BEM.blocks['b-hit'].reachGoal(jsParams.goal, jsParams.params);
                });
            }
        }
    }, {
        reachGoal: function () {
            var args = arguments;
            var yaCounter = w.yaCounter;

            if (!!yaCounter) {
                onLoad.then(function () {
                    reachGoal.apply(null, args);
                });
                return;
            }

            reachGoal.apply(null, args);
        },
        awaps: function (url, klass) {
            try {
                if (!url) {
                    return;
                }

                var img = document.createElement('img');
                img.src = url + (url.indexOf('?') >= 0 ? '&' : '?') + '_=' + Math.floor((Math.random() * 100000) + 1);

                img.className = klass;
                document.body.appendChild(img);
            } catch (e) {
            }
        }
    });

    function reachGoal(name, params) {
        // TOUCHRASP-1622
        if (typeof params === 'object') {
            params = Object.keys(params).reduce(function (newParams, key) {
                newParams[name + '-' + key] = params[key];

                return newParams;
            }, {});
        }
        try {
            var yaCounter = window.yaCounter;
            yaCounter.reachGoal(name, params);
        } catch (e) { }
    }

})(window);
