blocks.declare('b-mobile-lang-switcher', function (langSwitcherModel, mix) {
    if (!langSwitcherModel) {
        return;
    }

    var i18n = BEM.I18N.bind(BEM.I18N, 'b-mobile-lang-switcher');

    return {
        block: 'b-mobile-lang-switcher',
        mix: [{
            block: 'page-layout',
            elem: 'switcher',
            mods: {type: 'switch-lang'}
        }, mix],
        content: [
            {
                elem: 'lang',
                tag: 'span',
                content: langSwitcherModel.country
            },
            {
                block: 'icon',
                mods: {
                    size: 'flag',
                    theme: langSwitcherModel.country.toLowerCase() + '16'
                },
                mix: [{
                    block:'b-mobile-lang-switcher',
                    elem: 'flag'
                }]
            },
            {
                elem: 'change',
                tag: 'span',
                content: i18n('change-language')
            }
        ]
    };
});
