blocks.declare('b-page', function (data, page) {
    var eFavicons = data.favicons;
    eFavicons.elem = 'icon';

    var result = blocks.apply('b-page_type_' + page, data, {
        block: 'b-page',
        js: {
            login: data.yandexLogin,
            uid: data.uid
        },
        lang: data.lang,
        mods: {
            type: page
        },
        title: data.pageTitle,
        head: [
            {
                elem: 'css',
                url: data.stHost + 'static/touch.bundles/' + page + '/_' + page + '.css',
                ie: false
            },
            eFavicons,
            {
                elem: 'js', url: '//yastatic.net/jquery/1.8.3/jquery.min.js'
            },
            {
                elem: 'js',
                url: data.stHost + 'static/touch.bundles/' + page + '/_' + page + '.' + data.lang + '.pub.js'
            },
            {
                elem: 'meta',
                attrs: {
                    name: 'description',
                    content: BEM.I18N('b-page', 'meta', {
                        title: data.pageTitle
                    })
                }
            },
            {
                elem: 'link',
                attrs: {
                    name: 'canonical',
                    rel: data.urls.desktopVersionUrl
                }
            },
            data.urls.alternativeUrls.map(function (data) {
                return {
                    elem: 'link',
                    attrs: {
                        name: 'alternative',
                        rel: data.url,
                        hreflang: data.lang
                    }
                };
            })

        ],
        panels: [
            {
                elem: 'panel',
                tabName: 'services',
                title: BEM.I18N('services-table', 'title'),
                content: blocks.apply('services-table', data)
            }, data.langSwitcher && {
                elem: 'panel',
                tabName: 'switch-lang',
                title: BEM.I18N('b-change-langs', 'title'),
                content: blocks.apply('b-change-langs', data.langSwitcher)
            }, data.user.uid && {
                elem: 'panel',
                tabName: 'settings',
                title: BEM.I18N('b-user-settings', 'title'),
                content: blocks.apply('b-user-settings', data.userSettings)
            }
        ],
        footerAwaps: blocks.apply('b-footer-awaps', {
            teaser: data.teaser
        }),
        footer: blocks.apply('footer', {
            nationalVersion: data.nationalVersion,
            tuneDesktopVersionUrl: data.urls.tuneDesktopVersionUrl,
            feedbackUrl: data.urls.feedbackUrl,
            userAgreementUrl: data.urls.userAgreementUrl,
            langSwitcher: data.langSwitcher
        }),
        metrika: blocks.apply('b-metrika', data)
    });

    return [
        {
            block: 'i-global',
            params: data.global
        },
        result
    ];
});
